/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming.client.render.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.ItemStack;

public class WolfHotdogLayer
extends RenderLayer<Wolf, WolfModel<Wolf>> {
    public static final ModelLayerLocation HOTDOG_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"hotdog"), "hotdog");
    private static final ResourceLocation HOTDOG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"productivefarming", (String)"textures/entity/wolf/hotdog.png");
    private final WolfModel<Wolf> model;

    public WolfHotdogLayer(RenderLayerParent<Wolf, WolfModel<Wolf>> renderer, EntityModelSet models) {
        super(renderer);
        this.model = new WolfModel(models.bakeLayer(HOTDOG_LAYER));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Wolf livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        if (livingEntity.hasArmor()) {
            // empty if block
        }
    }

    private void maybeRenderHotdogLayer(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ItemStack armorStack) {
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)HOTDOG_TEXTURE));
        this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
    }

    public static MeshDefinition createMeshDefinition(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)-1.0f, (float)13.5f, (float)-7.0f));
        head.addOrReplaceChild("real_head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, cubeDeformation).texOffs(16, 14).addBox(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation).texOffs(16, 14).addBox(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, cubeDeformation).texOffs(0, 10).addBox(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, cubeDeformation), PartPose.ZERO);
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("upper_body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, cubeDeformation), PartPose.offsetAndRotation((float)-1.0f, (float)14.0f, (float)-3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation);
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset((float)-2.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset((float)0.5f, (float)16.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offset((float)-2.5f, (float)16.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder, PartPose.offset((float)0.5f, (float)16.0f, (float)-4.0f));
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("real_tail", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, cubeDeformation), PartPose.ZERO);
        body.addOrReplaceChild("hotdog", CubeListBuilder.create().texOffs(32, 46).addBox(-5.0f, -16.0f, -4.0f, 3.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(32, 28).addBox(2.0f, -16.0f, -4.0f, 3.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)).texOffs(0, 49).addBox(-2.0f, -17.0f, -3.0f, 4.0f, 4.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-11.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        return meshdefinition;
    }
}

