/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivefarming;

import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    private static final ModConfigSpec.Builder SERVER_BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.Builder STARTUP_BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SERVER_CONFIG;
    public static final ModConfigSpec STARTUP_CONFIG;
    public static final Server SERVER;
    public static final Startup STARTUP;

    static {
        SERVER = new Server(SERVER_BUILDER);
        STARTUP = new Startup(STARTUP_BUILDER);
        SERVER_CONFIG = SERVER_BUILDER.build();
        STARTUP_CONFIG = STARTUP_BUILDER.build();
    }

    public static class Server {
        public final ModConfigSpec.IntValue farmMaxVolume;
        public final ModConfigSpec.IntValue farmMaxCircumference;
        public final ModConfigSpec.IntValue farmMaxHeight;
        public final ModConfigSpec.IntValue feedingTroughTickRate;
        public final ModConfigSpec.IntValue wateringTroughTickRate;
        public final ModConfigSpec.IntValue fishTrapTickRate;
        public final ModConfigSpec.IntValue childSeparatorTickRate;
        public final ModConfigSpec.DoubleValue clamSpreadChance;
        public final ModConfigSpec.DoubleValue flowerPropagationChance;
        public final ModConfigSpec.DoubleValue traitIncreaseChance;
        public final ModConfigSpec.IntValue pollenChanceFromSieve;
        public final ModConfigSpec.BooleanValue traitsOnVanillaCrops;
        public final ModConfigSpec.BooleanValue spawnFlowersWithBonemeal;

        public Server(ModConfigSpec.Builder builder) {
            builder.push("General");
            this.farmMaxVolume = builder.comment("Max internal volume of the farm multiblock").defineInRange("farmMaxVolume", 1024, 1, Integer.MAX_VALUE);
            this.farmMaxCircumference = builder.comment("Max circumference of the farm multiblock").defineInRange("farmMaxCircumference", 200, 1, Integer.MAX_VALUE);
            this.farmMaxHeight = builder.comment("Max height of the farm multiblock").defineInRange("farmMaxHeight", 20, 1, Integer.MAX_VALUE);
            this.feedingTroughTickRate = builder.comment("Tickrate for Feeding Troughs").defineInRange("feedingTroughTickRate", 1200, 1, Integer.MAX_VALUE);
            this.wateringTroughTickRate = builder.comment("Tickrate for Watering Troughs").defineInRange("wateringTroughTickRate", 1200, 1, Integer.MAX_VALUE);
            this.fishTrapTickRate = builder.comment("Tickrate for Fishing Traps").defineInRange("fishTrapTickRate", 6000, 1, Integer.MAX_VALUE);
            this.childSeparatorTickRate = builder.comment("Tickrate for Child Separator").defineInRange("childSeparatorTickRate", 600, 1, Integer.MAX_VALUE);
            this.clamSpreadChance = builder.comment("Chance for clams to propagate in a fish farm").defineInRange("clamSpreadChance", 0.1, 0.0, 1.0);
            this.flowerPropagationChance = builder.comment("Chance for flowers to propagate near hives").defineInRange("flowerPropagationChance", 0.15, 0.0, 1.0);
            this.traitIncreaseChance = builder.comment("Chance for crops to increase traits when growing").defineInRange("traitIncreaseChance", 0.05, 0.0, 1.0);
            this.pollenChanceFromSieve = builder.comment("Chance to get a pollen when using sieve upgrades in hives").defineInRange("pollenChanceFromSieve", 2, 1, 100);
            this.traitsOnVanillaCrops = builder.comment("Add traits to vanilla crops. This will add components to vanilla crop items and the crop block will be overwritten.").define("traitsOnVanillaCrops", true);
            this.spawnFlowersWithBonemeal = builder.comment("Spawn productive farming flowers when using bonemeal on grass blocks").define("spawnFlowersWithBonemeal", false);
            builder.pop();
        }
    }

    public static class Startup {
        public final ModConfigSpec.BooleanValue villagersTradeSeeds;

        public Startup(ModConfigSpec.Builder builder) {
            builder.push("General");
            this.villagersTradeSeeds = builder.comment("Seeds can be obtained from farmer villager trades").define("villagersTradeSeeds", true);
            builder.pop();
        }
    }
}

