/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.util.math;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.moddingx.libx.codec.MoreStreamCodecs;
import org.moddingx.libx.util.math.Polynomial;

public final class DoublePolynomial
extends Polynomial<Double>
implements DoubleUnaryOperator,
DoubleFunction<Double> {
    public static final Codec<DoublePolynomial> CODEC = Codec.DOUBLE.listOf().xmap(doubles -> new DoublePolynomial(doubles.stream().dropWhile(d -> d == 0.0).mapToDouble(d -> d).toArray(), true), p -> p.coefficients.length == 0 ? List.of(Double.valueOf(0.0)) : Arrays.stream(p.coefficients).boxed().toList());
    public static final StreamCodec<ByteBuf, DoublePolynomial> STREAM_CODEC = MoreStreamCodecs.listOf(ByteBufCodecs.DOUBLE).map(doubles -> new DoublePolynomial(doubles.stream().mapToDouble(c -> c).dropWhile(d -> d == 0.0).toArray()), p -> p.coefficients.length == 0 ? List.of(Double.valueOf(0.0)) : Arrays.stream(p.coefficients).boxed().toList());
    public static final DoublePolynomial ZERO = new DoublePolynomial(0.0);
    public static final DoublePolynomial ONE = new DoublePolynomial(1.0);
    public static final DoublePolynomial IDENTITY = new DoublePolynomial(1.0, 0.0);
    private final double[] coefficients;
    private final boolean zero;
    private final boolean id;
    private List<Double> coefficientsView;

    private DoublePolynomial(double[] coefficients, boolean direct) {
        if (direct) {
            this.coefficients = coefficients;
        } else {
            int skip;
            for (skip = 0; skip < coefficients.length && coefficients[skip] == 0.0; ++skip) {
            }
            this.coefficients = new double[coefficients.length - skip];
            System.arraycopy(coefficients, skip, this.coefficients, 0, this.coefficients.length);
        }
        this.zero = this.coefficients.length == 0;
        this.id = this.coefficients.length == 2 && this.coefficients[0] == 1.0 && this.coefficients[1] == 0.0;
        this.coefficientsView = null;
    }

    public DoublePolynomial(double ... coefficients) {
        this(coefficients, false);
    }

    @Override
    public List<Double> coefficients() {
        if (this.coefficientsView != null) {
            return this.coefficientsView;
        }
        this.coefficientsView = Arrays.stream(this.coefficients).boxed().toList();
        return this.coefficientsView;
    }

    @Override
    public double applyAsDouble(double x) {
        if (this.zero) {
            return 0.0;
        }
        if (this.id) {
            return x;
        }
        double pow = 1.0;
        double result = 0.0;
        for (int i = this.coefficients.length - 1; i >= 0; --i) {
            result += this.coefficients[i] * pow;
            pow *= x;
        }
        return result;
    }

    @Override
    public Double apply(double x) {
        return this.applyAsDouble(x);
    }

    @Override
    public Double apply(Double x) {
        return this.applyAsDouble(x);
    }

    public DoublePolynomial derivative() {
        if (this.coefficients.length == 0) {
            return this;
        }
        double[] coefficients = new double[this.coefficients.length - 1];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = this.coefficients[i] * (double)(this.coefficients.length - i - 1);
        }
        return new DoublePolynomial(coefficients, true);
    }

    public DoublePolynomial integrate() {
        return this.integrate(0.0);
    }

    public DoublePolynomial integrate(double constant) {
        double[] coefficients = new double[this.coefficients.length + 1];
        for (int i = 0; i < coefficients.length - 1; ++i) {
            coefficients[i] = this.coefficients[i] / (double)(this.coefficients.length - i);
        }
        coefficients[coefficients.length - 1] = constant;
        return new DoublePolynomial(coefficients, false);
    }

    public DoublePolynomial negate() {
        if (this.coefficients.length == 0) {
            return this;
        }
        double[] coefficients = new double[this.coefficients.length];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = -this.coefficients[i];
        }
        return new DoublePolynomial(coefficients, true);
    }

    public DoublePolynomial add(Polynomial<Double> other) {
        double[] otherCoefficients = DoublePolynomial.trustedCoefficients(other);
        double[] coefficients = new double[Math.max(this.coefficients.length, otherCoefficients.length)];
        int thisOffset = coefficients.length - this.coefficients.length;
        int otherOffset = coefficients.length - otherCoefficients.length;
        for (int i = 0; i < coefficients.length; ++i) {
            double thisPart = i - thisOffset >= 0 ? this.coefficients[i - thisOffset] : 0.0;
            double otherPart = i - otherOffset >= 0 ? otherCoefficients[i - otherOffset] : 0.0;
            coefficients[i] = thisPart + otherPart;
        }
        return new DoublePolynomial(coefficients, false);
    }

    public DoublePolynomial multiply(Polynomial<Double> other) {
        double[] otherCoefficients = DoublePolynomial.trustedCoefficients(other);
        double[] coefficients = new double[this.coefficients.length + otherCoefficients.length];
        for (int i = 0; i < this.coefficients.length; ++i) {
            for (int j = 0; j < otherCoefficients.length; ++j) {
                int idx;
                int n = idx = coefficients.length - (this.coefficients.length - i - 1 + (otherCoefficients.length - j - 1)) - 1;
                coefficients[n] = coefficients[n] + this.coefficients[i] * otherCoefficients[j];
            }
        }
        return new DoublePolynomial(coefficients, false);
    }

    private static double[] trustedCoefficients(Polynomial<Double> other) {
        if (other instanceof DoublePolynomial) {
            DoublePolynomial polynomial = (DoublePolynomial)other;
            return polynomial.coefficients;
        }
        return other.coefficients().stream().mapToDouble(Double::valueOf).toArray();
    }

    public int hashCode() {
        return Arrays.hashCode(this.coefficients);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof DoublePolynomial)) return false;
        DoublePolynomial other = (DoublePolynomial)obj;
        if (!Arrays.equals(this.coefficients, other.coefficients)) return false;
        return true;
    }
}

