/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.sandbox.surface;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.moddingx.libx.sandbox.SandBox;
import org.moddingx.libx.sandbox.surface.BiomeSurface;

public record SurfaceRuleSet(boolean useDefaultNoiseSurface, SurfaceRules.RuleSource beforeBiomes, SurfaceRules.RuleSource afterBiomes, SurfaceRules.RuleSource defaultBiomeSurface) {
    public static final Codec<SurfaceRuleSet> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("use_default_noise_surface").orElse((Object)false).forGetter(SurfaceRuleSet::useDefaultNoiseSurface), (App)SurfaceRules.RuleSource.CODEC.fieldOf("before_biomes").forGetter(SurfaceRuleSet::beforeBiomes), (App)SurfaceRules.RuleSource.CODEC.fieldOf("after_biomes").forGetter(SurfaceRuleSet::afterBiomes), (App)SurfaceRules.RuleSource.CODEC.fieldOf("default_biome_surface").forGetter(SurfaceRuleSet::defaultBiomeSurface)).apply((Applicative)instance, SurfaceRuleSet::new));
    public static final Codec<Holder<SurfaceRuleSet>> CODEC = RegistryFileCodec.create(SandBox.SURFACE_RULE_SET, DIRECT_CODEC);

    public SurfaceRules.RuleSource build(Registry<Biome> biomeRegistry, Registry<BiomeSurface> surfaceRegistry, Set<Holder<Biome>> biomes, NoiseGeneratorSettings settings) {
        ArrayList<SurfaceRules.RuleSource> rules = new ArrayList<SurfaceRules.RuleSource>();
        rules.add(this.beforeBiomes());
        ArrayList<ResourceKey> biomesWithRules = new ArrayList<ResourceKey>();
        for (Holder<Biome> biome : biomes) {
            ResourceKey biomeKey;
            BiomeSurface biomeSurface;
            ResourceLocation id;
            if ((id = (switch (biome.kind()) {
                default -> throw new MatchException(null, null);
                case Holder.Kind.REFERENCE -> ((Holder.Reference)biome).key().location();
                case Holder.Kind.DIRECT -> biomeRegistry.getKey((Object)((Biome)biome.value()));
            })) == null || (biomeSurface = (BiomeSurface)surfaceRegistry.get(id)) == null || biomesWithRules.contains(biomeKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)id))) continue;
            biomesWithRules.add(biomeKey);
            rules.add(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)biomeSurface.rule()));
        }
        if (biomesWithRules.isEmpty()) {
            rules.add(this.defaultBiomeSurface());
        } else {
            rules.add(SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])((ResourceKey[])biomesWithRules.toArray(ResourceKey[]::new)))), (SurfaceRules.RuleSource)this.defaultBiomeSurface()));
        }
        rules.add(this.afterBiomes());
        if (this.useDefaultNoiseSurface()) {
            rules.add(settings.surfaceRule());
        }
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])rules.toArray(SurfaceRules.RuleSource[]::new)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

