/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.sandbox.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementFilter;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class HeightPlacementFilter
extends PlacementFilter {
    public static final MapCodec<HeightPlacementFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)VerticalAnchor.CODEC.fieldOf("min_inclusive").forGetter(filter -> filter.minInclusive), (App)VerticalAnchor.CODEC.fieldOf("max_inclusive").forGetter(filter -> filter.maxInclusive)).apply((Applicative)instance, HeightPlacementFilter::new));
    public static final PlacementModifierType<HeightPlacementFilter> TYPE = () -> CODEC;
    private final VerticalAnchor minInclusive;
    private final VerticalAnchor maxInclusive;

    public HeightPlacementFilter(VerticalAnchor minInclusive, VerticalAnchor maxInclusive) {
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
    }

    @Nonnull
    public PlacementModifierType<?> type() {
        return TYPE;
    }

    protected boolean shouldPlace(@Nonnull PlacementContext context, @Nonnull RandomSource random, @Nonnull BlockPos pos) {
        return this.minInclusive.resolveY((WorldGenerationContext)context) <= pos.getY() && this.maxInclusive.resolveY((WorldGenerationContext)context) >= pos.getY();
    }
}

