/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.sandbox.generator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.QuartPos;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import org.moddingx.libx.impl.sandbox.layer.NoiseLayerSelector;
import org.moddingx.libx.sandbox.SandBox;
import org.moddingx.libx.sandbox.generator.BiomeLayer;

public class LayeredBiomeSource
extends BiomeSource {
    public static final MapCodec<LayeredBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList(SandBox.BIOME_LAYER, BiomeLayer.DIRECT_CODEC).fieldOf("layers").forGetter(biomes -> biomes.layers)).apply((Applicative)instance, LayeredBiomeSource::new));
    private final HolderSet<BiomeLayer> layers;
    private NoiseLayerSelector sel;
    private MultiNoiseBiomeSource[] sources;
    private Climate.ParameterPoint[] ranges;

    public LayeredBiomeSource(HolderSet<BiomeLayer> layers) {
        this.layers = layers;
    }

    @Nonnull
    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        return this.layers.stream().flatMap(layer -> ((BiomeLayer)layer.value()).biomes().values().stream()).map(Pair::getSecond).distinct();
    }

    public void init(long seed) {
        List<BiomeLayer> layersInOrder = this.layers.stream().map(Holder::value).toList();
        this.sel = new NoiseLayerSelector(layersInOrder.stream().map(BiomeLayer::density).toList(), RandomSource.create((long)(seed * -6524552231151932243L)));
        this.ranges = (Climate.ParameterPoint[])layersInOrder.stream().map(BiomeLayer::range).toArray(Climate.ParameterPoint[]::new);
        this.sources = (MultiNoiseBiomeSource[])layersInOrder.stream().map(layer -> MultiNoiseBiomeSource.createFromList(layer.biomes())).toArray(MultiNoiseBiomeSource[]::new);
    }

    @Nonnull
    protected MapCodec<? extends BiomeSource> codec() {
        return CODEC;
    }

    private int getNoiseLayer(int x, int y, int z, @Nonnull Climate.TargetPoint target) {
        int i;
        if (this.sel == null) {
            throw new IllegalStateException("Random layer selector not initialised.");
        }
        if (this.sources.length == 1) {
            return 0;
        }
        int matchAmount = 0;
        int lastMatch = 0;
        boolean[] matches = new boolean[this.sources.length];
        for (i = 0; i < this.sources.length; ++i) {
            if (!LayeredBiomeSource.isInRange(this.ranges[i], target)) continue;
            ++matchAmount;
            matches[i] = true;
            lastMatch = i;
        }
        if (matchAmount == 1) {
            return lastMatch;
        }
        if (matchAmount == 0) {
            for (i = 0; i < this.sources.length; ++i) {
                matches[i] = true;
            }
        }
        return this.sel.sample(x, y, z, matches);
    }

    @Nonnull
    public Holder<Biome> getNoiseBiome(int x, int y, int z, @Nonnull Climate.Sampler sampler) {
        Climate.TargetPoint target = sampler.sample(x, y, z);
        return this.sources[this.getNoiseLayer(x, y, z, target)].getNoiseBiome(target);
    }

    private static boolean isInRange(Climate.ParameterPoint point, Climate.TargetPoint target) {
        if (point.temperature().distance(target.temperature()) != 0L) {
            return false;
        }
        if (point.humidity().distance(target.humidity()) != 0L) {
            return false;
        }
        if (point.continentalness().distance(target.continentalness()) != 0L) {
            return false;
        }
        if (point.erosion().distance(target.erosion()) != 0L) {
            return false;
        }
        if (point.depth().distance(target.depth()) != 0L) {
            return false;
        }
        return point.weirdness().distance(target.weirdness()) == 0L;
    }

    public void addDebugInfo(List<String> lines, BlockPos pos, Climate.Sampler sampler) {
        Climate.TargetPoint target = sampler.sample(QuartPos.fromBlock((int)pos.getX()), QuartPos.fromBlock((int)pos.getY()), QuartPos.fromBlock((int)pos.getZ()));
        float continentalness = Climate.unquantizeCoord((long)target.continentalness());
        float erosion = Climate.unquantizeCoord((long)target.erosion());
        float temperature = Climate.unquantizeCoord((long)target.temperature());
        float humidity = Climate.unquantizeCoord((long)target.humidity());
        float weirdness = Climate.unquantizeCoord((long)target.weirdness());
        double peaks = NoiseRouterData.peaksAndValleys((float)weirdness);
        OverworldBiomeBuilder builder = new OverworldBiomeBuilder();
        StringBuilder sb = new StringBuilder("Biome builder");
        sb.append(" PV: ").append(OverworldBiomeBuilder.getDebugStringForPeaksAndValleys((double)peaks));
        sb.append(" C: ").append(builder.getDebugStringForContinentalness((double)continentalness));
        sb.append(" E: ").append(builder.getDebugStringForErosion((double)erosion));
        sb.append(" T: ").append(builder.getDebugStringForTemperature((double)temperature));
        sb.append(" H: ").append(builder.getDebugStringForHumidity((double)humidity));
        lines.add(sb.toString());
        if (this.sel != null) {
            sb = new StringBuilder("Layer selector");
            sb.append(" L: ").append(this.getNoiseLayer(pos.getX(), pos.getY(), pos.getZ(), target));
            sb.append(" M: ").append(this.sources.length);
            lines.add(sb.toString());
        }
    }
}

