/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.util.lazy.LazyValue;

public class ItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final LazyValue<ItemStackRenderer> INSTANCE = new LazyValue<ItemStackRenderer>(() -> new ItemStackRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels()));
    private static final List<BlockEntityType<?>> types = Collections.synchronizedList(new LinkedList());
    private static final Map<Block, Pair<LazyValue<BlockEntity>, Boolean>> blocks = Collections.synchronizedMap(new HashMap());
    private static final Map<BlockEntityType<?>, CompoundTag> defaultTags = new HashMap();

    public ItemStackRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public static <T extends BlockEntity> void addRenderBlock(BlockEntityType<T> beType, boolean readBlockEntityTag) {
        types.add(beType);
        for (Block block : beType.getValidBlocks()) {
            blocks.put(block, (Pair<LazyValue<BlockEntity>, Boolean>)Pair.of(new LazyValue<BlockEntity>(() -> beType.create(BlockPos.ZERO, block.defaultBlockState())), (Object)readBlockEntityTag));
        }
    }

    public void renderByItem(ItemStack stack, @Nonnull ItemDisplayContext ctx, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Block block = Block.byItem((Item)stack.getItem());
        if (block != Blocks.AIR && blocks.containsKey(block)) {
            Pair<LazyValue<BlockEntity>, Boolean> pair = blocks.get(block);
            BlockState state = block.defaultBlockState();
            BlockEntity blockEntity = (BlockEntity)((LazyValue)pair.getLeft()).get();
            BlockEntityType teType = blockEntity.getType();
            BlockEntityRenderer renderer = this.blockEntityRenderDispatcher.getRenderer(blockEntity);
            if (renderer != null) {
                ItemStackRenderer.setLevelAndState(blockEntity, state);
                if (((Boolean)pair.getRight()).booleanValue() && Minecraft.getInstance().level != null) {
                    if (!defaultTags.containsKey(teType)) {
                        defaultTags.put(teType, blockEntity.saveCustomOnly((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
                    } else {
                        blockEntity.loadCustomOnly(defaultTags.get(teType), (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                    }
                    ItemStackRenderer.setLevelAndState(blockEntity, state);
                    CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
                    if (customData != null) {
                        customData.loadInto(blockEntity, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                    }
                }
                poseStack.pushPose();
                if (state.getRenderShape() != RenderShape.ENTITYBLOCK_ANIMATED) {
                    Minecraft.getInstance().getBlockRenderer().renderSingleBlock(block.defaultBlockState(), poseStack, buffer, light, overlay);
                }
                renderer.render(blockEntity, Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false), poseStack, buffer, light, overlay);
                poseStack.popPose();
            }
        }
    }

    private static void setLevelAndState(BlockEntity blockEntity, BlockState state) {
        if (Minecraft.getInstance().level != null) {
            blockEntity.setLevel((Level)Minecraft.getInstance().level);
        }
        blockEntity.blockState = state;
    }

    public static ItemStackRenderer get() {
        return INSTANCE.get();
    }

    public static IClientItemExtensions createProperties() {
        return new IClientItemExtensions(){

            @Nonnull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return ItemStackRenderer.get();
            }
        };
    }
}

