/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.menu.type;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.neoforge.network.IContainerFactory;
import org.moddingx.libx.menu.type.AdvancedMenuFactory;

public class AdvancedMenuType<T extends AbstractContainerMenu, S>
extends MenuType<T> {
    private final AdvancedMenuFactory<T, S> factory;
    @Nullable
    private final StreamCodec<? super RegistryFriendlyByteBuf, S> codec;

    private AdvancedMenuType(AtomicReference<MenuType<T>> menuTypeRef, AdvancedMenuFactory<T, S> factory, @Nullable StreamCodec<? super RegistryFriendlyByteBuf, S> codec, FeatureFlagSet featureFlags) {
        super(new Factory<T, S>(menuTypeRef, factory, codec), featureFlags);
        this.factory = factory;
        this.codec = codec;
        menuTypeRef.set(this);
    }

    public void open(ServerPlayer player, Component title, S payload) {
        Provider<T, S> provider = new Provider<T, S>(this, title, this.factory, payload);
        if (this.codec != null) {
            player.openMenu(provider, buf -> this.codec.encode(buf, payload));
        } else {
            player.openMenu(provider);
        }
    }

    public static <T extends AbstractContainerMenu> AdvancedMenuType<T, Void> create(AdvancedMenuFactory<T, Void> factory) {
        return AdvancedMenuType.create(factory, FeatureFlags.VANILLA_SET);
    }

    public static <T extends AbstractContainerMenu> AdvancedMenuType<T, Void> create(AdvancedMenuFactory<T, Void> factory, FeatureFlagSet featureFlags) {
        AtomicReference<MenuType<T>> menuTypeRef = new AtomicReference<MenuType<T>>();
        Objects.requireNonNull(factory);
        return new AdvancedMenuType<T, Void>(menuTypeRef, factory, null, featureFlags);
    }

    public static <T extends AbstractContainerMenu, S> AdvancedMenuType<T, S> create(AdvancedMenuFactory<T, S> factory, StreamCodec<? super RegistryFriendlyByteBuf, S> codec) {
        return AdvancedMenuType.create(factory, codec, FeatureFlags.VANILLA_SET);
    }

    public static <T extends AbstractContainerMenu, S> AdvancedMenuType<T, S> create(AdvancedMenuFactory<T, S> factory, StreamCodec<? super RegistryFriendlyByteBuf, S> codec, FeatureFlagSet featureFlags) {
        AtomicReference<MenuType<T>> menuTypeRef = new AtomicReference<MenuType<T>>();
        Objects.requireNonNull(factory);
        Objects.requireNonNull(codec);
        return new AdvancedMenuType<T, S>(menuTypeRef, factory, codec, featureFlags);
    }

    private static class Factory<T extends AbstractContainerMenu, S>
    implements IContainerFactory<T> {
        private final AtomicReference<MenuType<T>> menuType;
        private final AdvancedMenuFactory<T, S> factory;
        @Nullable
        private final StreamCodec<? super RegistryFriendlyByteBuf, S> codec;

        private Factory(AtomicReference<MenuType<T>> menuType, AdvancedMenuFactory<T, S> factory, @Nullable StreamCodec<? super RegistryFriendlyByteBuf, S> codec) {
            this.menuType = menuType;
            this.factory = factory;
            this.codec = codec;
        }

        @Nonnull
        public T create(int windowId, @Nonnull Inventory inventory, @Nullable RegistryFriendlyByteBuf data) {
            MenuType<T> menuType = Objects.requireNonNull(this.menuType.get());
            if (this.codec != null && data == null) {
                ResourceLocation id = BuiltInRegistries.MENU.getKey(menuType);
                throw new IllegalStateException("Can't open menus of type " + String.valueOf(id) + " without extra payload.");
            }
            Object payload = this.codec == null ? null : this.codec.decode((Object)data);
            return this.factory.createMenu(menuType, windowId, inventory.player.level(), payload, inventory.player, inventory);
        }
    }

    private static class Provider<T extends AbstractContainerMenu, S>
    implements MenuProvider {
        private final MenuType<T> menuType;
        private final Component title;
        private final AdvancedMenuFactory<T, S> factory;
        private final S payload;

        private Provider(MenuType<T> menuType, Component title, AdvancedMenuFactory<T, S> factory, S payload) {
            this.menuType = menuType;
            this.title = title;
            this.factory = factory;
            this.payload = payload;
        }

        @Nonnull
        public Component getDisplayName() {
            return this.title;
        }

        @Nullable
        public AbstractContainerMenu createMenu(int windowId, @Nonnull Inventory inventory, @Nonnull Player player) {
            return this.factory.createMenu(this.menuType, windowId, player.level(), this.payload, player, inventory);
        }
    }
}

