/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.inventory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.moddingx.libx.inventory.IAdvancedItemHandlerModifiable;

public class VanillaWrapper
implements Container {
    public final IItemHandlerModifiable handler;
    @Nullable
    public final Runnable changed;

    public VanillaWrapper(IItemHandlerModifiable handler, @Nullable Runnable changed) {
        this.handler = handler;
        this.changed = changed;
    }

    public int getContainerSize() {
        return this.handler.getSlots();
    }

    public boolean isEmpty() {
        for (int slot = 0; slot < this.handler.getSlots(); ++slot) {
            if (this.handler.getStackInSlot(slot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack getItem(int index) {
        return this.handler.getStackInSlot(index);
    }

    @Nonnull
    public ItemStack removeItem(int index, int count) {
        ItemStack stack = this.handler.extractItem(index, count, false);
        this.setChanged();
        return stack;
    }

    @Nonnull
    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.handler.getStackInSlot(index).copy();
        this.handler.setStackInSlot(index, ItemStack.EMPTY);
        this.setChanged();
        return stack;
    }

    public void setItem(int index, @Nonnull ItemStack stack) {
        this.handler.setStackInSlot(index, stack);
        this.setChanged();
    }

    public void setChanged() {
        if (this.changed != null) {
            this.changed.run();
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        return true;
    }

    public boolean canPlaceItem(int index, @Nonnull ItemStack stack) {
        return this.handler.isItemValid(index, stack);
    }

    public void clearContent() {
        IItemHandlerModifiable iItemHandlerModifiable = this.handler;
        if (iItemHandlerModifiable instanceof IAdvancedItemHandlerModifiable) {
            IAdvancedItemHandlerModifiable adv = (IAdvancedItemHandlerModifiable)iItemHandlerModifiable;
            adv.clear();
        } else {
            for (int i = 0; i < this.handler.getSlots(); ++i) {
                this.handler.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
    }
}

