/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.registration.handler;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.moddingx.libx.impl.registration.handler.SpecialRegistrationHandler;
import org.moddingx.libx.registration.util.ClientExtensionInfo;

public class ClientExtensionRegistrationHandler
extends SpecialRegistrationHandler {
    private final Map<ResourceLocation, ClientExtensionInfo.Item> items = new HashMap<ResourceLocation, ClientExtensionInfo.Item>();
    private final Map<ResourceLocation, ClientExtensionInfo.Block> blocks = new HashMap<ResourceLocation, ClientExtensionInfo.Block>();
    private final Map<ResourceLocation, ClientExtensionInfo.Fluid> fluids = new HashMap<ResourceLocation, ClientExtensionInfo.Fluid>();
    private final Map<ResourceLocation, ClientExtensionInfo.MobEffect> mobEffects = new HashMap<ResourceLocation, ClientExtensionInfo.MobEffect>();
    private final Map<ResourceLocation, ClientExtensionInfo.MenuScreen<?, ?>> menuScreens = new HashMap();

    public ClientExtensionRegistrationHandler(Runnable runRegistration) {
        super(runRegistration);
    }

    @Override
    public void handle(ResourceLocation id, Object object) {
        if (object instanceof ClientExtensionInfo.Item) {
            ClientExtensionInfo.Item itemInfo = (ClientExtensionInfo.Item)object;
            this.addToMap("ClientExtensionInfo.Item", this.items, id, itemInfo);
        }
        if (object instanceof ClientExtensionInfo.Block) {
            ClientExtensionInfo.Block blockInfo = (ClientExtensionInfo.Block)object;
            this.addToMap("ClientExtensionInfo.Block", this.blocks, id, blockInfo);
        }
        if (object instanceof ClientExtensionInfo.Fluid) {
            ClientExtensionInfo.Fluid fluidInfo = (ClientExtensionInfo.Fluid)object;
            this.addToMap("ClientExtensionInfo.Fluid", this.fluids, id, fluidInfo);
        }
        if (object instanceof ClientExtensionInfo.MobEffect) {
            ClientExtensionInfo.MobEffect mobEffectInfo = (ClientExtensionInfo.MobEffect)object;
            this.addToMap("ClientExtensionInfo.MobEffect", this.mobEffects, id, mobEffectInfo);
        }
        if (object instanceof ClientExtensionInfo.MenuScreen) {
            ClientExtensionInfo.MenuScreen menuScreenInfo = (ClientExtensionInfo.MenuScreen)object;
            this.addToMap("ClientExtensionInfo.MenuScreen", this.menuScreens, id, menuScreenInfo);
        }
    }

    public void registerClientExtensions(RegisterClientExtensionsEvent event) {
        this.runRegistration();
        for (Map.Entry<ResourceLocation, ClientExtensionInfo.Item> entry : this.items.entrySet()) {
            Item item = BuiltInRegistries.ITEM.getOptional(entry.getKey()).orElse(null);
            if (item == null) {
                throw new IllegalStateException("ClientExtensionInfo.Item registered for unknown item: " + String.valueOf(entry.getKey()));
            }
            event.registerItem(entry.getValue().extensions().get(), new Item[]{item});
        }
        for (Map.Entry<ResourceLocation, Record> entry : this.blocks.entrySet()) {
            Block block = BuiltInRegistries.BLOCK.getOptional(entry.getKey()).orElse(null);
            if (block == null) {
                throw new IllegalStateException("ClientExtensionInfo.Block registered for unknown block: " + String.valueOf(entry.getKey()));
            }
            event.registerBlock(((ClientExtensionInfo.Block)entry.getValue()).extensions().get(), new Block[]{block});
        }
        for (Map.Entry<ResourceLocation, Record> entry : this.fluids.entrySet()) {
            FluidType fluidType = NeoForgeRegistries.FLUID_TYPES.getOptional(entry.getKey()).orElse(null);
            if (fluidType == null) {
                throw new IllegalStateException("ClientExtensionInfo.Fluid registered for unknown fluid type: " + String.valueOf(entry.getKey()));
            }
            event.registerFluidType(((ClientExtensionInfo.Fluid)entry.getValue()).extensions().get(), new FluidType[]{fluidType});
        }
        for (Map.Entry<ResourceLocation, Record> entry : this.mobEffects.entrySet()) {
            MobEffect effect = BuiltInRegistries.MOB_EFFECT.getOptional(entry.getKey()).orElse(null);
            if (effect == null) {
                throw new IllegalStateException("ClientExtensionInfo.MobEffect registered for unknown mob effect: " + String.valueOf(entry.getKey()));
            }
            event.registerMobEffect(((ClientExtensionInfo.MobEffect)entry.getValue()).extensions().get(), new MobEffect[]{effect});
        }
    }

    public void registerMenuScreens(RegisterMenuScreensEvent event) {
        this.runRegistration();
        for (Map.Entry<ResourceLocation, ClientExtensionInfo.MenuScreen<?, ?>> entry : this.menuScreens.entrySet()) {
            MenuType menuType = BuiltInRegistries.MENU.getOptional(entry.getKey()).orElse(null);
            if (menuType == null) {
                throw new IllegalStateException("ClientExtensionInfo.MenuScreen registered for unknown menu type: " + String.valueOf(entry.getKey()));
            }
            if (menuType != entry.getValue().menuType()) {
                ResourceLocation expectedId = BuiltInRegistries.MENU.getKey(entry.getValue().menuType());
                throw new IllegalStateException("ClientExtensionInfo.MenuScreen registered with wrong id, expected " + String.valueOf(expectedId) + ", got " + String.valueOf(entry.getKey()));
            }
            ClientExtensionRegistrationHandler.registerMenuScreenTo(event, entry.getValue());
        }
    }

    private static <T extends AbstractContainerMenu, U extends Screen> void registerMenuScreenTo(RegisterMenuScreensEvent event, ClientExtensionInfo.MenuScreen<T, U> menuScreenInfo) {
        event.register(menuScreenInfo.menuType(), menuScreenInfo.screenConstructor());
    }
}

