/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.registration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.impl.registration.EntryCollectorImpl;
import org.moddingx.libx.impl.registration.handler.CapabilityRegistrationHandler;
import org.moddingx.libx.impl.registration.handler.ClientExtensionRegistrationHandler;
import org.moddingx.libx.mod.ModXRegistration;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationBuilder;
import org.moddingx.libx.registration.RegistrationContext;
import org.moddingx.libx.registration.RegistryCondition;
import org.moddingx.libx.registration.RegistryTransformer;
import org.moddingx.libx.registration.SetupContext;

public class RegistrationDispatcher {
    private final Object LOCK = new Object();
    private final ModXRegistration mod;
    private final List<RegistryCondition> conditions;
    private final List<RegistryTransformer> transformers;
    private boolean hasRegistrationRun;
    private final List<Runnable> registrationHandlers;
    private final Map<ResourceKey<? extends Registry<?>>, RegistryData> allEntries;
    private final List<NamedRegisterable> registerables;
    private final CapabilityRegistrationHandler capabilityHandler;
    @Nullable
    private final ClientExtensionRegistrationHandler clientExtHandler;

    public RegistrationDispatcher(ModXRegistration mod, RegistrationBuilder.Result result) {
        this.mod = mod;
        this.conditions = result.conditions();
        this.transformers = result.transformers();
        this.hasRegistrationRun = false;
        this.registrationHandlers = new ArrayList<Runnable>();
        this.allEntries = new HashMap();
        this.registerables = new LinkedList<NamedRegisterable>();
        this.capabilityHandler = new CapabilityRegistrationHandler(this::runRegistration);
        this.clientExtHandler = FMLLoader.getDist() == Dist.CLIENT ? new ClientExtensionRegistrationHandler(this::runRegistration) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRegistration() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.hasRegistrationRun) {
                return;
            }
            this.hasRegistrationRun = true;
        }
        this.registrationHandlers.forEach(Runnable::run);
    }

    public void setupEventListeners(IEventBus modBus) {
        modBus.addListener(this::registerBy);
        modBus.addListener(this::registerCommon);
        modBus.addListener(this::registerClient);
        modBus.addListener(this.capabilityHandler::registerCapabilities);
        if (this.clientExtHandler != null) {
            modBus.addListener(this.clientExtHandler::registerClientExtensions);
            modBus.addListener(this.clientExtHandler::registerMenuScreens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRegistrationHandler(Runnable handler) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.hasRegistrationRun) {
                throw new IllegalStateException("Can't add a registration handler after the registration has run.");
            }
            this.registrationHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void register(@Nullable ResourceKey<? extends Registry<T>> registry, String id, T value) {
        Object object = this.LOCK;
        synchronized (object) {
            ResourceLocation rl = this.mod.resource(id);
            ResourceKey resourceKey = registry == null ? null : ResourceKey.create(registry, (ResourceLocation)rl);
            RegistrationContext ctx = new RegistrationContext(this.mod, rl, resourceKey);
            List<RegistryCondition> failedConditions = this.conditions.stream().filter(condition -> !condition.shouldRegister(ctx, value)).toList();
            if (!failedConditions.isEmpty()) {
                return;
            }
            EntryCollectorImpl collector = new EntryCollectorImpl(this, id);
            this.transformers.forEach(transformer -> transformer.transform(ctx, value, collector));
            if (registry != null) {
                this.addEntry(resourceKey, value);
            }
            this.capabilityHandler.handle(rl, value);
            if (this.clientExtHandler != null) {
                this.clientExtHandler.handle(rl, value);
            }
            if (value instanceof Registerable) {
                Registerable registerable = (Registerable)value;
                this.registerables.add(new NamedRegisterable(ctx, registerable));
                registerable.registerAdditional(ctx, collector);
                if (FMLLoader.getDist() == Dist.CLIENT) {
                    RegisterableClientAdapter.registerClientAdditional(registerable, ctx, collector);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(ResourceKey<?> resourceKey, Object element) {
        Object object = this.LOCK;
        synchronized (object) {
            RegistryData data = this.allEntries.computeIfAbsent(ResourceKey.createRegistryKey((ResourceLocation)resourceKey.registry()), k -> new RegistryData());
            data.add(resourceKey, element);
        }
    }

    private void registerBy(RegisterEvent event) {
        this.runRegistration();
        RegistryData data = this.allEntries.get(event.getRegistryKey());
        if (data != null) {
            event.register(event.getRegistryKey(), reg -> {
                for (Map.Entry entry : data.values()) {
                    reg.register(((ResourceKey)entry.getKey()).location(), entry.getValue());
                }
            });
        }
    }

    private void registerCommon(FMLCommonSetupEvent event) {
        this.runRegistration();
        this.registerables.forEach(reg -> reg.registerCommon(arg_0 -> ((FMLCommonSetupEvent)event).enqueueWork(arg_0)));
    }

    private void registerClient(FMLClientSetupEvent event) {
        this.runRegistration();
        this.registerables.forEach(reg -> reg.registerClient(arg_0 -> ((FMLClientSetupEvent)event).enqueueWork(arg_0)));
    }

    private record NamedRegisterable(RegistrationContext ctx, Registerable value) {
        public void registerCommon(Consumer<Runnable> enqueue) {
            this.value().setupCommon(new SetupContext(this.ctx(), enqueue));
        }

        public void registerClient(Consumer<Runnable> enqueue) {
            if (FMLLoader.getDist() == Dist.CLIENT) {
                RegisterableClientAdapter.registerClient(this.value(), new SetupContext(this.ctx(), enqueue));
            }
        }
    }

    private static class RegisterableClientAdapter {
        private RegisterableClientAdapter() {
        }

        public static void registerClient(Registerable registerable, SetupContext ctx) {
            registerable.setupClient(ctx);
        }

        public static void registerClientAdditional(Registerable registerable, RegistrationContext ctx, Registerable.EntryCollector builder) {
            registerable.registerClientAdditional(ctx, builder);
        }

        static {
            if (FMLLoader.getDist().isDedicatedServer()) {
                throw new IllegalStateException("RegisterableClientAdapter should never be loaded on the dedicated server. This is a bug in LibX.");
            }
        }
    }

    private static final class RegistryData {
        private final Set<ResourceKey<?>> keys = new HashSet();
        private final List<Pair<ResourceKey<?>, Object>> values = new ArrayList();

        private RegistryData() {
        }

        public void add(ResourceKey<?> key, Object value) {
            if (this.keys.contains(key)) {
                throw new IllegalStateException("Duplicate element for registration: " + String.valueOf(key) + " with value " + String.valueOf(value));
            }
            this.keys.add(key);
            this.values.add(Pair.of(key, (Object)value));
        }

        public List<Pair<ResourceKey<?>, Object>> values() {
            return Collections.unmodifiableList(this.values);
        }
    }
}

