/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.config.gui.screen.content.component.type;

import java.util.Arrays;
import java.util.Formattable;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.ConfigScreenContent;
import org.moddingx.libx.config.gui.WidgetProperties;
import org.moddingx.libx.impl.config.gui.EditorHelper;
import org.moddingx.libx.impl.config.gui.screen.content.CollectionContent;
import org.moddingx.libx.impl.config.gui.screen.content.component.ComponentContent;
import org.moddingx.libx.impl.config.gui.screen.content.component.ComponentType;

public class TranslationComponentType
implements ComponentType {
    private final ConfigEditor<String> editor = ConfigEditor.input();
    private final ConfigEditor<List<Component>> argEditor = ConfigEditor.custom(List.of(), l -> new CollectionContent<Component, List<Component>>(this, l, ConfigEditor.custom(Component.empty(), ComponentContent::new), Function.identity(), true){

        @Override
        public Component message() {
            return Component.translatable((String)"libx.config.gui.component.arguments");
        }
    });
    private String value = "";
    private AbstractWidget widget;
    private List<Component> args;
    private AbstractWidget argWidget;
    private Consumer<MutableComponent> inputChanged;

    @Override
    public Component name() {
        return Component.translatable((String)"libx.config.gui.component.type_translate");
    }

    @Override
    public MutableComponent defaultValue() {
        return Component.translatable((String)"");
    }

    @Override
    @Nullable
    public MutableComponent init(Component component, Consumer<MutableComponent> inputChanged) {
        this.inputChanged = inputChanged;
        ComponentContents componentContents = component.getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            this.value = tc.getKey();
            this.args = Arrays.stream(tc.getArgs()).map(TranslationComponentType::wrap).toList();
            return component.plainCopy();
        }
        return null;
    }

    private void update() {
        if (this.inputChanged != null) {
            this.inputChanged.accept(Component.translatable((String)this.value, (Object[])this.args.toArray()));
        }
    }

    @Override
    public void buildGui(Screen screen, ConfigScreenContent.ScreenManager manager, AtomicInteger y, Consumer<AbstractWidget> consumer) {
        WidgetProperties<String> properties = new WidgetProperties<String>(5, y.get(), manager.contentWidth() - 10, 20, value -> {
            this.value = value;
            this.update();
        });
        this.widget = EditorHelper.create(screen, this.editor, this.value, this.widget, properties);
        consumer.accept(this.widget);
        y.addAndGet(23);
        WidgetProperties<List> argProperties = new WidgetProperties<List>(5, y.get(), 180, 20, args -> {
            this.args = args;
            this.update();
        });
        this.argWidget = EditorHelper.create(screen, this.argEditor, this.args, this.argWidget, argProperties);
        consumer.accept(this.argWidget);
        y.addAndGet(23);
    }

    private static Component wrap(Object obj) {
        if (obj instanceof Component) {
            Component c = (Component)obj;
            return c;
        }
        if (obj instanceof Formattable) {
            Formattable f = (Formattable)obj;
            Formatter formatter = new Formatter();
            f.formatTo(formatter, 0, -1, -1);
            return Component.literal((String)formatter.toString());
        }
        return Component.literal((String)obj.toString());
    }
}

