/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.impl.codec;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Optional;
import java.util.stream.Stream;

public class TrueOptionalMapCodec<A>
extends MapCodec<Optional<A>> {
    private final Codec<A> codec;
    private final String name;

    public TrueOptionalMapCodec(Codec<A> codec, String name) {
        this.name = name;
        this.codec = codec;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.name));
    }

    public <T> DataResult<Optional<A>> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = input.get(this.name);
        if (value == null) {
            return DataResult.success(Optional.empty());
        }
        return this.codec.parse(ops, value).map(Optional::of);
    }

    public <T> RecordBuilder<T> encode(Optional<A> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        if (input.isPresent()) {
            return prefix.add(this.name, this.codec.encodeStart(ops, input.get()));
        }
        return prefix;
    }

    public String toString() {
        return "TrueOptionalMapCodec[" + this.name + ": " + String.valueOf(this.codec) + "]";
    }
}

