/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.texture;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.provider.texture.TextureBuilder;
import org.moddingx.libx.datagen.provider.texture.TextureFactory;
import org.moddingx.libx.datagen.provider.texture.Textures;
import org.moddingx.libx.impl.datagen.texture.HangingSignTextureFactory;
import org.moddingx.libx.impl.datagen.texture.SignTextureFactory;
import org.moddingx.libx.impl.datagen.texture.TextureGenerator;
import org.moddingx.libx.mod.ModX;

public abstract class TextureProviderBase
implements DataProvider {
    private final ModX mod;
    private final TextureGenerator generator;
    private final Map<ResourceLocation, TextureFactory> textures;

    protected TextureProviderBase(DatagenContext ctx) {
        this.mod = ctx.mod();
        this.generator = new TextureGenerator(ctx.target());
        this.textures = new HashMap<ResourceLocation, TextureFactory>();
    }

    @Nonnull
    public String getName() {
        return this.mod.modid + " textures.";
    }

    public abstract void setup();

    public void texture(String loc, TextureFactory factory) {
        this.texture(this.mod.resource(loc), factory);
    }

    public void image(String loc, TextureFactory factory) {
        this.image(this.mod.resource(loc), factory);
    }

    public void texture(ResourceLocation loc, TextureFactory factory) {
        this.image(ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)("textures/" + loc.getPath() + ".png")), factory);
    }

    public void image(ResourceLocation loc, TextureFactory factory) {
        this.textures.put(loc, factory);
    }

    public void sign(WoodType wood, Block log, Block planks) {
        ResourceLocation logId = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)log));
        ResourceLocation planksId = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)planks));
        this.sign(wood, ResourceLocation.fromNamespaceAndPath((String)logId.getNamespace(), (String)("block/" + logId.getPath())), ResourceLocation.fromNamespaceAndPath((String)planksId.getNamespace(), (String)("block/" + planksId.getPath())));
    }

    public void sign(WoodType wood, ResourceLocation log, ResourceLocation planks) {
        ResourceLocation woodId = ResourceLocation.parse((String)wood.name());
        this.sign(ResourceLocation.fromNamespaceAndPath((String)woodId.getNamespace(), (String)("entity/signs/" + woodId.getPath())), log, planks);
    }

    public void sign(ResourceLocation signTexture, ResourceLocation log, ResourceLocation planks) {
        this.texture(signTexture, (TextureFactory)new SignTextureFactory(log, planks));
    }

    public void hangingSign(WoodType wood, Block strippedLog) {
        ResourceLocation logId = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)strippedLog));
        this.hangingSign(wood, ResourceLocation.fromNamespaceAndPath((String)logId.getNamespace(), (String)("block/" + logId.getPath())));
    }

    public void hangingSign(WoodType wood, ResourceLocation strippedLog) {
        ResourceLocation woodId = ResourceLocation.parse((String)wood.name());
        this.hangingSign(ResourceLocation.fromNamespaceAndPath((String)woodId.getNamespace(), (String)("entity/signs/hanging/" + woodId.getPath())), strippedLog);
    }

    public void hangingSign(ResourceLocation signTexture, ResourceLocation strippedLog) {
        this.texture(signTexture, (TextureFactory)new HangingSignTextureFactory(strippedLog));
    }

    @Nonnull
    public CompletableFuture<?> run(@Nonnull CachedOutput output) {
        this.setup();
        return CompletableFuture.allOf((CompletableFuture[])this.textures.entrySet().stream().map(entry -> {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            TextureFactory factory = (TextureFactory)entry.getValue();
            TextureBuilder builder = new TextureBuilder(this.mod, this.generator::loadImage);
            factory.addTextures(builder);
            Textures textures = builder.build();
            Dimension dim = factory.getSize();
            BufferedImage image = this.generator.newImage(dim.width, dim.height, textures.scale());
            factory.generate(image, textures);
            return this.generator.save(output, id, image);
        }).toArray(CompletableFuture[]::new));
    }
}

