/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.sandbox;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.biome.OverworldBiomes;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.DatagenStage;
import org.moddingx.libx.datagen.provider.RegistryProviderBase;

public abstract class BiomeProviderBase
extends RegistryProviderBase {
    protected BiomeProviderBase(DatagenContext ctx) {
        super(ctx, DatagenStage.REGISTRY_SETUP);
    }

    @Override
    public final String getName() {
        return this.mod.modid + " biomes";
    }

    public BiomeBuilder biome(float temperature, float downfall) {
        return new BiomeBuilder(temperature, downfall);
    }

    public BiomeSpecialEffects.Builder effects() {
        return new BiomeEffectsBuilder();
    }

    public MobSpawnSettings.Builder spawns() {
        return new BiomeSpawnsBuilder();
    }

    public BiomeGenerationSettings.Builder generation() {
        return new BiomeGenerationBuilder(this);
    }

    public class BiomeBuilder {
        private final float temperature;
        private final Biome.BiomeBuilder builder;

        private BiomeBuilder(float temperature, float downfall) {
            this.temperature = temperature;
            this.builder = new Biome.BiomeBuilder();
            this.builder.temperature(temperature);
            this.builder.downfall(downfall);
            this.builder.temperatureAdjustment(Biome.TemperatureModifier.NONE);
            this.effects(BiomeProviderBase.this.effects());
        }

        public BiomeBuilder frozen() {
            this.builder.temperatureAdjustment(Biome.TemperatureModifier.FROZEN);
            return this;
        }

        public BiomeBuilder effects(BiomeSpecialEffects.Builder builder) {
            if (!(builder instanceof BiomeEffectsBuilder)) {
                throw new IllegalArgumentException("Use BiomeData#effects to create a BiomeSpecialEffects.Builder instance.");
            }
            BiomeEffectsBuilder effectBuilder = (BiomeEffectsBuilder)builder;
            effectBuilder.setDefaultSkyColor(this.temperature);
            this.builder.specialEffects(builder.build());
            return this;
        }

        public BiomeBuilder mobSpawns(MobSpawnSettings.Builder builder) {
            if (!(builder instanceof BiomeSpawnsBuilder)) {
                throw new IllegalArgumentException("Use BiomeData#spawns to create a MobSpawnSettings.Builder instance.");
            }
            this.builder.mobSpawnSettings(builder.build());
            return this;
        }

        public BiomeBuilder generation(BiomeGenerationSettings.PlainBuilder builder) {
            if (!(builder instanceof BiomeGenerationBuilder)) {
                throw new IllegalArgumentException("Use BiomeData#generation to create a BiomeGenerationSettings.Builder instance.");
            }
            this.builder.generationSettings(builder.build());
            return this;
        }

        public Holder<Biome> build() {
            return BiomeProviderBase.this.registries.writableRegistry(Registries.BIOME).createIntrusiveHolder((Object)this.builder.build());
        }
    }

    private static class BiomeEffectsBuilder
    extends BiomeSpecialEffects.Builder {
        private BiomeEffectsBuilder() {
            this.fogColor(12638463);
            this.waterColor(4159204);
            this.waterFogColor(329011);
        }

        private void setDefaultSkyColor(float temperature) {
            if (this.skyColor.isEmpty()) {
                this.skyColor(OverworldBiomes.calculateSkyColor((float)temperature));
            }
        }
    }

    private static class BiomeSpawnsBuilder
    extends MobSpawnSettings.Builder {
        private BiomeSpawnsBuilder() {
        }
    }

    private class BiomeGenerationBuilder
    extends BiomeGenerationSettings.Builder {
        private BiomeGenerationBuilder(BiomeProviderBase biomeProviderBase) {
            super((HolderGetter)biomeProviderBase.registries.registry(Registries.PLACED_FEATURE).asLookup(), (HolderGetter)biomeProviderBase.registries.registry(Registries.CONFIGURED_CARVER).asLookup());
        }
    }
}

