/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.patchouli;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.moddingx.libx.datagen.provider.patchouli.content.TextContent;
import org.moddingx.libx.datagen.provider.patchouli.page.Content;
import org.moddingx.libx.datagen.provider.patchouli.page.PageBuilder;
import org.moddingx.libx.datagen.provider.patchouli.page.PageJson;
import org.moddingx.libx.impl.datagen.patchouli.content.DoubleRecipePage;
import org.moddingx.libx.impl.datagen.patchouli.content.EntityContent;
import org.moddingx.libx.impl.datagen.patchouli.content.FlipContent;
import org.moddingx.libx.impl.datagen.patchouli.content.ImageContent;
import org.moddingx.libx.impl.datagen.patchouli.content.MultiblockContent;
import org.moddingx.libx.impl.datagen.patchouli.content.SpotlightContent;
import org.moddingx.libx.mod.ModX;

public class EntryBuilder {
    public final ModX mod;
    public final String id;
    public final ResourceLocation category;
    private String name;
    private ItemStack icon;
    private ResourceLocation advancement;
    private Content content;
    private final List<Consumer<JsonObject>> postProcessors;

    public EntryBuilder(ModX mod, String id, ResourceLocation category) {
        this.mod = mod;
        this.id = id;
        this.category = category;
        this.name = null;
        this.icon = null;
        this.advancement = null;
        this.content = Content.EMPTY;
        this.postProcessors = new ArrayList<Consumer<JsonObject>>();
    }

    public EntryBuilder name(String name) {
        this.name = name;
        return this;
    }

    public EntryBuilder icon(ItemLike icon) {
        return this.icon(new ItemStack(icon));
    }

    public EntryBuilder icon(ItemStack icon) {
        this.icon = icon.copy();
        return this;
    }

    public EntryBuilder advancement(String path) {
        return this.advancement(this.mod.modid, path);
    }

    public EntryBuilder advancement(String namespace, String path) {
        return this.advancement(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public EntryBuilder advancement(ResourceLocation advancement) {
        this.advancement = advancement;
        return this;
    }

    public EntryBuilder text(String text) {
        return this.add(new TextContent(text, false));
    }

    public EntryBuilder caption(String text) {
        return this.add(new TextContent(text, true));
    }

    public EntryBuilder flip() {
        return this.add(new FlipContent(null));
    }

    public EntryBuilder flip(String anchor) {
        return this.add(new FlipContent(anchor));
    }

    public EntryBuilder image(String title, String ... images) {
        return this.image(title, (ResourceLocation[])Arrays.stream(images).map(s -> ResourceLocation.fromNamespaceAndPath((String)this.mod.modid, (String)s)).toArray(ResourceLocation[]::new));
    }

    public EntryBuilder image(String title, ResourceLocation ... images) {
        return this.add(new ImageContent(title, List.of(images), null));
    }

    public EntryBuilder crafting(String path) {
        return this.crafting(this.mod.modid, path);
    }

    public EntryBuilder crafting(String namespace, String path) {
        return this.crafting(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public EntryBuilder crafting(ResourceLocation id) {
        return this.add(new DoubleRecipePage("patchouli:crafting", 8, id));
    }

    public EntryBuilder smelting(String path) {
        return this.smelting(this.mod.modid, path);
    }

    public EntryBuilder smelting(String namespace, String path) {
        return this.smelting(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
    }

    public EntryBuilder smelting(ResourceLocation id) {
        return this.add(new DoubleRecipePage("patchouli:smelting", 4, id));
    }

    public EntryBuilder item(ItemLike stack) {
        return this.item(new ItemStack(stack), true);
    }

    public EntryBuilder item(ItemLike stack, boolean linkRecipe) {
        return this.item(new ItemStack(stack), linkRecipe);
    }

    public EntryBuilder item(ItemStack stack) {
        return this.item(stack, true);
    }

    public EntryBuilder item(ItemStack stack, boolean linkRecipe) {
        return this.add(new SpotlightContent(stack, linkRecipe));
    }

    public EntryBuilder entity(EntityType<?> entity) {
        return this.add(new EntityContent(entity));
    }

    public EntryBuilder multiblock(String title, String data) {
        return this.add(new MultiblockContent(title, data));
    }

    public EntryBuilder add(Content content) {
        this.content = this.content.with(content);
        return this;
    }

    public EntryBuilder postProcess(Consumer<JsonObject> postProcessor) {
        this.postProcessors.add(postProcessor);
        return this;
    }

    JsonObject build(final BiFunction<String, List<String>, String> translations, final ExistingFileHelper fileHelper) {
        if (this.name == null) {
            throw new IllegalStateException("Entry name not set: " + String.valueOf(this.category) + "/" + this.id);
        }
        if (this.icon == null) {
            throw new IllegalStateException("Entry icon not set: " + String.valueOf(this.category) + "/" + this.id);
        }
        JsonObject json = new JsonObject();
        json.addProperty("name", translations.apply(this.name, List.of("entry", this.mod.modid, this.category.getNamespace(), this.category.getPath(), this.id)));
        json.addProperty("category", this.category.toString());
        json.add("icon", PageJson.stack(this.icon));
        if (this.advancement != null) {
            json.addProperty("advancement", this.advancement.toString());
        }
        final JsonArray pages = new JsonArray();
        PageBuilder builder = new PageBuilder(){
            private int page = 0;
            private int key = 0;
            private String anchor = null;

            @Override
            public boolean isFirst() {
                return this.page == 0;
            }

            @Override
            public void addPage(JsonObject page) {
                ++this.page;
                this.key = 0;
                if (this.anchor != null) {
                    if (page.has("anchor")) {
                        throw new IllegalStateException("Can't add pending anchor '" + this.anchor + "', page already has an anchor set: '" + page.get("anchor").getAsString() + "'");
                    }
                    page.addProperty("anchor", this.anchor);
                    this.anchor = null;
                }
                pages.add((JsonElement)page);
            }

            @Override
            public void addAnchor(String name) {
                if (this.anchor != null) {
                    throw new IllegalStateException("Can't add anchor '" + name + "', already a pending anchor: '" + this.anchor + "'");
                }
                this.anchor = name;
            }

            @Override
            public String translate(String localized) {
                return (String)translations.apply(localized, List.of("entry", EntryBuilder.this.mod.modid, EntryBuilder.this.category.getNamespace(), EntryBuilder.this.category.getPath(), EntryBuilder.this.id, "page" + this.page, "text" + this.key++));
            }

            @Override
            public void flipToEven() {
                if (this.page % 2 != 0) {
                    JsonObject json = new JsonObject();
                    json.addProperty("type", "patchouli:empty");
                    this.addPage(json);
                }
            }

            @Override
            public void checkAssets(ResourceLocation path) {
                if (!fileHelper.exists(path, PackType.CLIENT_RESOURCES)) {
                    throw new IllegalStateException("Resource " + String.valueOf(path) + " does not exist.");
                }
            }
        };
        this.content.pages(builder);
        json.add("pages", (JsonElement)pages);
        for (Consumer<JsonObject> postProcessor : this.postProcessors) {
            postProcessor.accept(json);
        }
        return json;
    }
}

