/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider.loot;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.provider.loot.LootProviderBase;
import org.moddingx.libx.datagen.provider.loot.entry.LootModifier;

public abstract class EntityLootProviderBase
extends LootProviderBase<EntityType<?>> {
    protected EntityLootProviderBase(DatagenContext ctx) {
        super(ctx, "entities", LootContextParamSets.ENTITY, Registries.ENTITY_TYPE);
    }

    @Override
    @Nullable
    protected LootTable.Builder defaultBehavior(EntityType<?> item) {
        return null;
    }

    public LootModifier<EntityType<?>> looting(int max) {
        return this.looting(0, max);
    }

    public LootModifier<EntityType<?>> looting(int min, int max) {
        HolderLookup.Provider enchantmentHolderProvider = HolderLookup.Provider.create(Stream.of(this.registries.registry(Registries.ENCHANTMENT).asLookup()));
        return this.modifier((entity, entry) -> entry.apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)enchantmentHolderProvider, (NumberProvider)UniformGenerator.between((float)min, (float)max))));
    }

    public LootItemCondition.Builder fire() {
        return LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().flags(EntityFlagsPredicate.Builder.flags().setOnFire(Boolean.valueOf(true))));
    }

    public LootModifier<EntityType<?>> smeltOnFire() {
        return this.modifier((entity, entry) -> entry.apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(new GiveMeAccessToShouldSmeltLoot().accessibleShouldSmeltLoot())));
    }

    private static class GiveMeAccessToShouldSmeltLoot
    extends EntityLootSubProvider {
        protected GiveMeAccessToShouldSmeltLoot() {
            super(FeatureFlagSet.of(), HolderLookup.Provider.create(Stream.of(new HolderLookup.RegistryLookup[0])));
        }

        public void generate() {
        }

        public LootItemCondition.Builder accessibleShouldSmeltLoot() {
            return this.shouldSmeltLoot();
        }
    }
}

