/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.datagen.provider;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicates;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.PackTarget;
import org.moddingx.libx.datagen.RegistrySet;
import org.moddingx.libx.datapack.DatapackHelper;
import org.moddingx.libx.mod.ModX;

public abstract class AdvancementProviderBase
implements DataProvider {
    protected final ModX mod;
    protected final PackTarget packTarget;
    private final RegistrySet registries;
    private final Map<ResourceLocation, Supplier<AdvancementInfo>> advancements = new HashMap<ResourceLocation, Supplier<AdvancementInfo>>();
    private String rootId = null;
    private Supplier<AdvancementInfo> rootSupplier = null;

    public AdvancementProviderBase(DatagenContext ctx) {
        this.mod = ctx.mod();
        this.packTarget = ctx.target();
        this.registries = ctx.registries();
    }

    public abstract void setup();

    protected List<ICondition> conditions() {
        return List.of();
    }

    @Nonnull
    public String getName() {
        return this.mod.modid + " advancements";
    }

    @Nonnull
    public CompletableFuture<?> run(@Nonnull CachedOutput cache) {
        this.setup();
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registries.registryAccess());
        return CompletableFuture.allOf((CompletableFuture[])this.advancements.entrySet().stream().map(entry -> {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.ADVANCEMENT, (ResourceLocation)id);
            AdvancementInfo advancementInfo = (AdvancementInfo)((Supplier)entry.getValue()).get();
            if (advancementInfo.advancement() == null) {
                return CompletableFuture.completedFuture(null);
            }
            WithConditions conditionalAdvancement = new WithConditions(this.conditions(), (Object)advancementInfo.advancement());
            JsonElement json = (JsonElement)Advancement.CONDITIONAL_CODEC.encodeStart((DynamicOps)ops, Optional.of(conditionalAdvancement)).getOrThrow(RuntimeException::new);
            Path path = this.packTarget.path(PackType.SERVER_DATA).resolve(DatapackHelper.registryPath(key));
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public AdvancementFactory root() {
        return this.root(this.mod.modid);
    }

    public AdvancementFactory root(String id) {
        return this.root(this.mod.modid, id);
    }

    public AdvancementFactory root(String namespace, String id) {
        if (id.equals("recipes")) {
            throw new IllegalStateException("Can't 'recipes' as root advancement id. Use a recipe provider to generate recipe advancements.");
        }
        if (this.rootId != null || this.rootSupplier != null) {
            throw new IllegalStateException("Can't use multiple root advancements in the same provider. Use multiple providers for this.");
        }
        if (!this.advancements.isEmpty()) {
            throw new IllegalStateException("The root advancement must be the first advancement that is configured.");
        }
        AdvancementFactory factory = new AdvancementFactory(namespace, id);
        if (this.advancements.put(factory.id, factory::build) != null) {
            throw new IllegalStateException("Duplicate root advancement: " + id);
        }
        this.rootId = id;
        this.rootSupplier = factory::build;
        return factory;
    }

    public void advancement(ResourceLocation id, Advancement advancement) {
        if (this.advancements.put(id, () -> new AdvancementInfo(id, advancement)) != null) {
            throw new IllegalStateException("Duplicate advancement: " + String.valueOf(id));
        }
    }

    public AdvancementFactory advancement(ResourceLocation id) {
        AdvancementFactory factory = new AdvancementFactory(id);
        if (this.advancements.put(id, factory::build) != null) {
            throw new IllegalStateException("Duplicate advancement: " + String.valueOf(id));
        }
        return factory;
    }

    public AdvancementFactory advancement(String id) {
        return this.advancement(this.idFor(id));
    }

    private ResourceLocation idFor(String id) {
        if (this.rootId == null) {
            throw new IllegalStateException("On advancement providers without a root advancement only fully qualified resource locations are allowed, no plain ids.");
        }
        return this.mod.resource(this.rootId + "/" + id);
    }

    public Criterion<?> items(ItemLike ... items) {
        return this.items((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.item().of(new ItemLike[]{item}).build()).toArray(ItemPredicate[]::new));
    }

    @SafeVarargs
    public final Criterion<?> items(TagKey<Item> ... items) {
        return this.items((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.item().of(item).build()).toArray(ItemPredicate[]::new));
    }

    public Criterion<?> items(ItemPredicate ... items) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])items);
    }

    public TaskFactory itemTasks(ItemLike ... items) {
        return this.itemTasks((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.item().of(new ItemLike[]{item}).build()).toArray(ItemPredicate[]::new));
    }

    @SafeVarargs
    public final TaskFactory itemTasks(TagKey<Item> ... items) {
        return this.itemTasks((ItemPredicate[])Arrays.stream(items).map(item -> ItemPredicate.Builder.item().of(item).build()).toArray(ItemPredicate[]::new));
    }

    public TaskFactory itemTasks(ItemPredicate ... items) {
        return () -> Arrays.stream(items).map(item -> List.of(this.items((ItemPredicate)item))).toList();
    }

    public Criterion<?> eat() {
        return ConsumeItemTrigger.TriggerInstance.usedItem();
    }

    public Criterion<?> eat(ItemLike food) {
        return this.eat(ItemPredicate.Builder.item().of(new ItemLike[]{food}));
    }

    public Criterion<?> eat(TagKey<Item> food) {
        return this.eat(ItemPredicate.Builder.item().of(food));
    }

    public Criterion<?> eat(ItemPredicate.Builder food) {
        return ConsumeItemTrigger.TriggerInstance.usedItem((ItemPredicate.Builder)food);
    }

    public Criterion<?> leave(ResourceKey<Level> dimension) {
        return ChangeDimensionTrigger.TriggerInstance.changedDimensionFrom(dimension);
    }

    public Criterion<?> enter(ResourceKey<Level> dimension) {
        return ChangeDimensionTrigger.TriggerInstance.changedDimensionTo(dimension);
    }

    public Criterion<?> changeDim(ResourceKey<Level> from, ResourceKey<Level> to) {
        return ChangeDimensionTrigger.TriggerInstance.changedDimension(from, to);
    }

    public ContextAwarePredicate entity(EntityPredicate entity) {
        return ContextAwarePredicate.create((LootItemCondition[])new LootItemCondition[]{LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)entity).build()});
    }

    public ContextAwarePredicate entity(EntityType<?> type) {
        return this.entity(EntityPredicate.Builder.entity().of(type).build());
    }

    @SafeVarargs
    public final ItemPredicate.Builder stack(ItemLike item, ResourceKey<Enchantment> ... enchs) {
        ItemPredicate.Builder builder = ItemPredicate.Builder.item().of(new ItemLike[]{item});
        return this.applyEnchantments(builder, enchs);
    }

    @SafeVarargs
    public final ItemPredicate.Builder stack(TagKey<Item> item, ResourceKey<Enchantment> ... enchs) {
        ItemPredicate.Builder builder = ItemPredicate.Builder.item().of(item);
        return this.applyEnchantments(builder, enchs);
    }

    @SafeVarargs
    public final ItemPredicate.Builder stack(ResourceKey<Enchantment> ... enchs) {
        if (enchs.length == 0) {
            throw new IllegalStateException("stack() can't be used to obtain an allways matching predicate.");
        }
        ItemPredicate.Builder builder = ItemPredicate.Builder.item();
        return this.applyEnchantments(builder, enchs);
    }

    public ItemPredicate.Builder stack(ResourceKey<Enchantment> ench, int min) {
        Registry registry = this.registries.registry(Registries.ENCHANTMENT);
        EnchantmentPredicate enchantmentPredicate = new EnchantmentPredicate((Holder)registry.getHolderOrThrow(ench), MinMaxBounds.Ints.atLeast((int)min));
        return ItemPredicate.Builder.item().withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(List.of(enchantmentPredicate)));
    }

    private ItemPredicate.Builder applyEnchantments(ItemPredicate.Builder builder, ResourceKey<Enchantment>[] enchantments) {
        if (enchantments.length == 0) {
            return builder;
        }
        Registry registry = this.registries.registry(Registries.ENCHANTMENT);
        List<EnchantmentPredicate> enchantmentPredicates = Arrays.stream(enchantments).map(key -> new EnchantmentPredicate((Holder)registry.getHolderOrThrow(key), MinMaxBounds.Ints.ANY)).toList();
        return builder.withSubPredicate(ItemSubPredicates.ENCHANTMENTS, (ItemSubPredicate)ItemEnchantmentsPredicate.enchantments(enchantmentPredicates));
    }

    public class AdvancementFactory {
        private final ResourceLocation id;
        private final boolean root;
        private Supplier<AdvancementInfo> parent;
        @Nullable
        private DisplayInfo display;
        @Nullable
        private ResourceLocation background;
        private final List<List<Criterion<?>>> criteria = new ArrayList();
        private AdvancementRewards reward = AdvancementRewards.EMPTY;
        private boolean telmetryEvent;

        private AdvancementFactory(String namespace, String rootId) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(rootId + "/root"));
            this.root = true;
            this.parent = () -> null;
            this.telmetryEvent = false;
        }

        private AdvancementFactory(ResourceLocation id) {
            this.id = id;
            this.root = false;
            this.parent = () -> null;
        }

        public AdvancementFactory parent(ResourceLocation id) {
            if (this.root) {
                throw new IllegalStateException("Can't set parent for root advancement.");
            }
            if (!AdvancementProviderBase.this.advancements.containsKey(id)) {
                throw new IllegalStateException("Parent advancement unknown: " + String.valueOf(id));
            }
            this.parent = AdvancementProviderBase.this.advancements.get(id);
            return this;
        }

        public AdvancementFactory parent(String id) {
            if (this.root) {
                throw new IllegalStateException("Can't set parent for root advancement.");
            }
            return this.parent(AdvancementProviderBase.this.idFor(id));
        }

        public AdvancementFactory foreignParent(ResourceLocation id) {
            if (this.root) {
                throw new IllegalStateException("Can't set parent for root advancement.");
            }
            this.parent = () -> new AdvancementInfo(id, null);
            return this;
        }

        public AdvancementFactory display(ItemLike icon) {
            return this.display(new ItemStack(icon));
        }

        public AdvancementFactory display(ItemLike icon, AdvancementType type) {
            return this.display(new ItemStack(icon), type);
        }

        public AdvancementFactory display(ItemLike icon, AdvancementType type, boolean toast, boolean chat, boolean hidden) {
            return this.display(new ItemStack(icon), type, toast, chat, hidden);
        }

        public AdvancementFactory display(ItemStack icon) {
            return this.display(icon, AdvancementType.TASK);
        }

        public AdvancementFactory display(ItemStack icon, AdvancementType type) {
            return this.display(icon, type, !this.root, !this.root, false);
        }

        public AdvancementFactory display(ItemStack icon, AdvancementType type, boolean toast, boolean chat, boolean hidden) {
            return this.display(icon, (Component)Component.translatable((String)("advancements." + this.id.getNamespace() + "." + this.id.getPath().replace('/', '.') + ".title")), (Component)Component.translatable((String)("advancements." + this.id.getNamespace() + "." + this.id.getPath().replace('/', '.') + ".description")), type, toast, chat, hidden);
        }

        public AdvancementFactory display(ItemLike icon, Component title, Component description) {
            return this.display(new ItemStack(icon), title, description);
        }

        public AdvancementFactory display(ItemLike icon, Component title, Component description, AdvancementType type) {
            return this.display(new ItemStack(icon), title, description, type);
        }

        public AdvancementFactory display(ItemLike icon, Component title, Component description, AdvancementType type, boolean toast, boolean chat, boolean hidden) {
            return this.display(new ItemStack(icon), title, description, type, toast, chat, hidden);
        }

        public AdvancementFactory display(ItemStack icon, Component title, Component description) {
            return this.display(icon, title, description, AdvancementType.TASK);
        }

        public AdvancementFactory display(ItemStack icon, Component title, Component description, AdvancementType type) {
            return this.display(icon, title, description, type, !this.root, !this.root, false);
        }

        public AdvancementFactory display(ItemStack icon, Component title, Component description, AdvancementType type, boolean toast, boolean chat, boolean hidden) {
            this.display = new DisplayInfo(icon, title, description, Optional.empty(), type, toast, chat, hidden);
            return this;
        }

        public AdvancementFactory background(ResourceLocation background) {
            if (!this.root) {
                throw new IllegalStateException("Can't set background on non-root advancement.");
            }
            this.background = background;
            return this;
        }

        public AdvancementFactory task(Criterion<?> ... criteria) {
            if (criteria.length == 0) {
                throw new IllegalStateException("Can not add empty task to advancement.");
            }
            this.criteria.add(List.of(criteria));
            return this;
        }

        public AdvancementFactory tasks(Criterion<?> ... criteria) {
            if (criteria.length == 0) {
                throw new IllegalStateException("Can not add empty task to advancement.");
            }
            for (Criterion<?> criterion : criteria) {
                this.criteria.add(List.of(criterion));
            }
            return this;
        }

        public AdvancementFactory tasks(TaskFactory factory) {
            for (List<Criterion<?>> task : factory.apply()) {
                this.task((Criterion[])task.toArray(Criterion[]::new));
            }
            return this;
        }

        public AdvancementFactory reward(AdvancementRewards reward) {
            this.reward = reward;
            return this;
        }

        public AdvancementFactory sendsTelmetryEvent() {
            this.telmetryEvent = true;
            return this;
        }

        private AdvancementInfo build() {
            Advancement parentAdv;
            if (this.criteria.isEmpty()) {
                throw new IllegalStateException("Can not add advancement without tasks.");
            }
            HashSet<String> idsTaken = new HashSet<String>();
            ArrayList criteriaIds = new ArrayList();
            HashMap criteriaMap = new HashMap();
            for (List<Criterion<?>> criterionGroup : this.criteria) {
                ArrayList<Object> criterionGroupIds = new ArrayList<Object>();
                for (Criterion<?> criterion : criterionGroup) {
                    CriterionTrigger trigger = Objects.requireNonNull(criterion.trigger(), "Can't build advancement: Empty criterion");
                    ResourceLocation triggerId = Objects.requireNonNull(BuiltInRegistries.TRIGGER_TYPES.getKey((Object)trigger), "Unregistered criterion trigger");
                    String baseName = "minecraft".equals(triggerId.getNamespace()) ? triggerId.getPath() : triggerId.toString();
                    baseName = baseName.replace(':', '_').replace('.', '_').replace('/', '_');
                    Object nextId = baseName;
                    int num = 2;
                    while (idsTaken.contains(nextId)) {
                        nextId = baseName + num++;
                    }
                    idsTaken.add((String)nextId);
                    criterionGroupIds.add(nextId);
                    criteriaMap.put(nextId, criterion);
                }
                criteriaIds.add(List.copyOf(criterionGroupIds));
            }
            AdvancementInfo parent = this.parent.get();
            ResourceLocation parentId = parent == null ? null : parent.id();
            Advancement advancement = parentAdv = parentId == null ? null : parent.advancement();
            if (this.root && parentId != null) {
                throw new IllegalStateException("Root advancement can not have a parent.");
            }
            if (!this.root && parentId == null) {
                if (AdvancementProviderBase.this.rootSupplier != null) {
                    parent = AdvancementProviderBase.this.rootSupplier.get();
                    parentId = parent == null ? null : parent.id();
                    Advancement advancement2 = parentAdv = parentId == null ? null : parent.advancement();
                    if (parentAdv == null) {
                        throw new IllegalStateException("Root advancement configured wrongly. This is an error in LibX.");
                    }
                } else {
                    throw new IllegalStateException("This advancement provider has no default root and the advancement " + String.valueOf(this.id) + " has no root specified.");
                }
            }
            DisplayInfo displayInfo = this.display;
            if (this.root) {
                if (this.display == null) {
                    throw new IllegalStateException("Can't build root advancement without display.");
                }
                if (this.background == null) {
                    throw new IllegalStateException("Can't build root advancement without background.");
                }
                displayInfo = new DisplayInfo(this.display.getIcon(), this.display.getTitle(), this.display.getDescription(), Optional.ofNullable(this.background), this.display.getType(), this.display.shouldShowToast(), this.display.shouldAnnounceChat(), this.display.isHidden());
            }
            if (parentAdv != null && parentAdv.display().isEmpty() && displayInfo != null) {
                throw new IllegalStateException("Can't build advancement with display and display-less parent.");
            }
            if (parentAdv != null && parentAdv.display().isPresent() && displayInfo != null && ((DisplayInfo)parentAdv.display().get()).isHidden() && !displayInfo.isHidden()) {
                throw new IllegalStateException("Can't build visible advancement with hidden parent.");
            }
            Advancement advancement3 = new Advancement(Optional.ofNullable(parentId), Optional.ofNullable(displayInfo), this.reward, criteriaMap, new AdvancementRequirements(List.copyOf(criteriaIds)), this.telmetryEvent);
            return new AdvancementInfo(this.id, advancement3);
        }
    }

    public static interface TaskFactory {
        public List<List<Criterion<?>>> apply();
    }

    private record AdvancementInfo(ResourceLocation id, @Nullable Advancement advancement) {
    }
}

