/*
 * Decompiled with CFR 0.152.
 */
package org.moddingx.libx.crafting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class RecipeHelper {
    public static <I extends RecipeInput, T extends Recipe<I>> boolean isItemValidInput(RecipeManager rm, RecipeType<T> recipeType, ItemStack stack) {
        List recipes = rm.getAllRecipesFor(recipeType);
        for (RecipeHolder recipe : recipes) {
            for (Ingredient ingredient : recipe.value().getIngredients()) {
                if (!ingredient.test(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean matches(Recipe<?> recipe, List<ItemStack> stacks, boolean exactMatch) {
        ArrayList<Integer> countsLeft = new ArrayList<Integer>();
        for (ItemStack stack : stacks) {
            countsLeft.add(stack.isEmpty() ? 0 : stack.getCount());
        }
        block1: for (Ingredient ingredient : recipe.getIngredients()) {
            for (int i = 0; i < stacks.size(); ++i) {
                if ((Integer)countsLeft.get(i) <= 0 || !ingredient.test(stacks.get(i))) continue;
                countsLeft.set(i, (Integer)countsLeft.get(i) - 1);
                continue block1;
            }
            return false;
        }
        return !exactMatch || countsLeft.stream().noneMatch(count -> count > 0);
    }

    public static List<ItemStack> stackUp(List<ItemStack> stacks) {
        ArrayList<ItemStack> stacked = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            int itemsLeft = stack.getCount();
            for (ItemStack used : stacked) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)used)) continue;
                int stackTransfer = Math.min(itemsLeft, used.getMaxStackSize() - used.getCount());
                if (stackTransfer < 0) {
                    stackTransfer = 0;
                }
                used.grow(stackTransfer);
                itemsLeft -= stackTransfer;
            }
            if (itemsLeft <= 0) continue;
            ItemStack newStack = stack.copy();
            newStack.setCount(itemsLeft);
            stacked.add(newStack);
        }
        return Collections.unmodifiableList(stacked);
    }
}

