/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.strategy;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import gripe._90.arseng.me.key.SourceKey;
import gripe._90.arseng.me.key.SourceKeyType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceStorageImportStrategy
implements StackImportStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceStorageImportStrategy.class);
    private final BlockCapabilityCache<ISourceCap, Direction> cache;

    public SourceStorageImportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockCapabilityCache.create((BlockCapability)CapabilityRegistry.SOURCE_CAPABILITY, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
    }

    public boolean transfer(StackTransferContext context) {
        if (!context.isKeyTypeEnabled(SourceKeyType.TYPE)) {
            return false;
        }
        ISourceCap sourceTile = (ISourceCap)this.cache.getCapability();
        if (sourceTile == null) {
            return false;
        }
        int remainingTransferAmount = context.getOperationsRemaining() * SourceKeyType.TYPE.getAmountPerOperation();
        int rawAmount = Math.min(remainingTransferAmount, sourceTile.getSource());
        MEStorage inv = context.getInternalStorage().getInventory();
        int amount = (int)inv.insert((AEKey)SourceKey.KEY, (long)rawAmount, Actionable.SIMULATE, context.getActionSource());
        if (amount > 0 && sourceTile.canProvideSource(amount)) {
            sourceTile.extractSource(amount, false);
            long inserted = inv.insert((AEKey)SourceKey.KEY, (long)amount, Actionable.MODULATE, context.getActionSource());
            if (inserted < (long)amount) {
                long leftover = (long)amount - inserted;
                int backFill = (int)Math.min(leftover, (long)(sourceTile.getSourceCapacity() - sourceTile.getSource()));
                if (backFill > 0) {
                    sourceTile.receiveSource(backFill, false);
                }
                if (leftover > (long)backFill) {
                    LOGGER.error("Storage import issue, voided {} source.", (Object)(leftover - (long)backFill));
                }
            }
            long opsUsed = Math.max(1L, inserted / (long)SourceKeyType.TYPE.getAmountPerOperation());
            context.reduceOperationsRemaining(opsUsed);
        }
        return amount > 0;
    }
}

