/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.block.entity;

import appeng.api.AECapabilities;
import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkedBlockEntity;
import com.hollingsworth.arsnouveau.api.source.ISourceCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import gripe._90.arseng.definition.ArsEngBlockEntities;
import gripe._90.arseng.me.key.SourceKey;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class MESourceJarBlockEntity
extends AENetworkedBlockEntity
implements ISourceCap,
ServerTickingBlockEntity {
    private final IActionSource actionSource = IActionSource.ofMachine((IActionHost)this);
    private int clientSideFill;

    public MESourceJarBlockEntity(BlockPos pos, BlockState blockState) {
        super(ArsEngBlockEntities.ME_SOURCE_JAR.get(), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    public static void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, ArsEngBlockEntities.ME_SOURCE_JAR.get(), (be, ctx) -> be);
        event.registerBlockEntity(CapabilityRegistry.SOURCE_CAPABILITY, ArsEngBlockEntities.ME_SOURCE_JAR.get(), (be, ctx) -> be);
    }

    public int receiveSource(int source, boolean simulate) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null && this.getMainNode().isActive() ? (int)StorageHelper.poweredInsert((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)SourceKey.KEY, (long)source, (IActionSource)this.actionSource, (Actionable)Actionable.ofSimulate((boolean)simulate)) : 0;
    }

    public int extractSource(int source, boolean simulate) {
        IGrid grid = this.getMainNode().getGrid();
        return grid != null && this.getMainNode().isActive() ? (int)StorageHelper.poweredExtraction((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)SourceKey.KEY, (long)source, (IActionSource)this.actionSource, (Actionable)Actionable.ofSimulate((boolean)simulate)) : 0;
    }

    public boolean canAcceptSource(int source) {
        return this.receiveSource(source, true) > 0;
    }

    public boolean canProvideSource(int source) {
        return this.extractSource(source, true) > 0;
    }

    public int getMaxExtract() {
        return this.getMainNode().isActive() ? Integer.MAX_VALUE : 0;
    }

    public int getMaxReceive() {
        return this.getMainNode().isActive() ? Integer.MAX_VALUE : 0;
    }

    public int getSource() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return this.clientSideFill;
        }
        return this.getMainNode().isActive() ? (int)grid.getStorageService().getInventory().extract((AEKey)SourceKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource) : 0;
    }

    public int getSourceCapacity() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return 10000;
        }
        return this.getMainNode().isActive() ? (int)grid.getStorageService().getInventory().insert((AEKey)SourceKey.KEY, Integer.MAX_VALUE, Actionable.SIMULATE, this.actionSource) : 0;
    }

    public void setSource(int source) {
        throw new UnsupportedOperationException();
    }

    public void setMaxSource(int max) {
        throw new UnsupportedOperationException();
    }

    protected void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeVarInt(this.clampedFill());
    }

    protected boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        int oldFill = this.clientSideFill;
        this.clientSideFill = data.readVarInt();
        return changed || oldFill != this.clientSideFill;
    }

    protected void saveVisualState(CompoundTag data) {
        super.saveVisualState(data);
        data.putInt("fill", this.clampedFill());
    }

    protected void loadVisualState(CompoundTag data) {
        super.loadVisualState(data);
        this.clientSideFill = data.getInt("fill");
    }

    public void serverTick() {
        int fill = this.clampedFill();
        if (this.clientSideFill != fill) {
            this.clientSideFill = fill;
            this.saveChanges();
            this.markForUpdate();
        }
    }

    public int clampedFill() {
        return Math.min(this.getSource(), 10000);
    }

    public Set<Direction> getGridConnectableSides(BlockOrientation orientation) {
        return Set.of(Direction.UP, Direction.DOWN, orientation.getSide(RelativeSide.BACK));
    }
}

