/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.client.gui.IStorageControllerGui;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.network.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class MessageUpdateLinkedMachines
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"update_linked_machines");
    public static final CustomPacketPayload.Type<MessageUpdateLinkedMachines> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageUpdateLinkedMachines> STREAM_CODEC = CustomPacketPayload.codec(MessageUpdateLinkedMachines::encode, MessageUpdateLinkedMachines::new);
    private List<MachineReference> linkedMachines;

    public MessageUpdateLinkedMachines(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageUpdateLinkedMachines(List<MachineReference> linkedMachines) {
        this.linkedMachines = linkedMachines;
    }

    public MessageUpdateLinkedMachines(Map<GlobalBlockPos, MachineReference> linkedMachines) {
        this.linkedMachines = new ArrayList<MachineReference>(linkedMachines.values());
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        IStorageControllerGui gui;
        Screen screen = minecraft.screen;
        if (screen instanceof IStorageControllerGui && (gui = (IStorageControllerGui)screen) != null) {
            gui.setLinkedMachines(this.linkedMachines);
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.linkedMachines.size());
        for (MachineReference machineReference : this.linkedMachines) {
            MachineReference.STREAM_CODEC.encode((Object)buf, (Object)machineReference);
        }
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        int linkedMachinesSize = buf.readInt();
        this.linkedMachines = new ArrayList<MachineReference>(linkedMachinesSize);
        for (int i = 0; i < linkedMachinesSize; ++i) {
            MachineReference machineReference = (MachineReference)MachineReference.STREAM_CODEC.decode((Object)buf);
            this.linkedMachines.add(machineReference);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

