/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageUpdateMouseHeldItem;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class MessageTakeItem
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"take_item");
    public static final CustomPacketPayload.Type<MessageTakeItem> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageTakeItem> STREAM_CODEC = CustomPacketPayload.codec(MessageTakeItem::encode, MessageTakeItem::new);
    private ItemStack stack = ItemStack.EMPTY;
    private int mouseButton;
    private boolean isShiftDown;
    private boolean isCtrlDown;

    public MessageTakeItem(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageTakeItem(ItemStack stack, int mouseButton, boolean isShiftDown, boolean isCtrlDown) {
        this.mouseButton = mouseButton;
        this.stack = stack;
        this.isShiftDown = isShiftDown;
        this.isCtrlDown = isCtrlDown;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        if (player.containerMenu instanceof IStorageControllerContainer) {
            IStorageController storageController = ((IStorageControllerContainer)player.containerMenu).getStorageController();
            if (storageController == null) {
                return;
            }
            int available = storageController.getAvailableAmount(new ItemStackComparator(this.stack, true));
            int amountRequested = 0;
            if (this.isCtrlDown) {
                amountRequested = 1;
            } else if (this.mouseButton == 0) {
                amountRequested = this.stack.getMaxStackSize();
            } else if (this.mouseButton == 1) {
                amountRequested = Math.min(this.stack.getMaxStackSize() / 2, available / 2);
            }
            amountRequested = Math.max(amountRequested, 1);
            ItemStack stack = storageController.getItemStack(new ItemStackComparator(this.stack, true), amountRequested, false);
            if (stack.isEmpty()) {
                stack = storageController.getItemStack(new ItemStackComparator(this.stack, false), amountRequested, false);
            }
            if (!stack.isEmpty()) {
                if (this.isShiftDown) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
                } else {
                    player.containerMenu.setCarried(stack);
                    Networking.sendTo(player, new MessageUpdateMouseHeldItem(stack));
                }
            }
            Networking.sendTo(player, storageController.getMessageUpdateStacks());
            player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
        ItemStack toWrite = this.stack.copyWithCount(1);
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)toWrite);
        buf.writeInt(this.stack.getCount());
        buf.writeByte(this.mouseButton);
        buf.writeBoolean(this.isShiftDown);
        buf.writeBoolean(this.isCtrlDown);
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
        this.stack = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
        this.stack.setCount(buf.readInt());
        this.mouseButton = buf.readByte();
        this.isShiftDown = buf.readBoolean();
        this.isCtrlDown = buf.readBoolean();
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

