/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.jei.impl;

import com.klikli_dev.occultism.common.container.storage.StableWormholeContainer;
import com.klikli_dev.occultism.common.container.storage.StorageControllerContainer;
import com.klikli_dev.occultism.common.container.storage.StorageRemoteContainer;
import com.klikli_dev.occultism.integration.BoundBookRecipeMaker;
import com.klikli_dev.occultism.integration.jei.impl.JeiRecipeTypes;
import com.klikli_dev.occultism.integration.jei.impl.StorageControllerRecipeTransferHandler;
import com.klikli_dev.occultism.integration.jei.impl.recipes.CrushingRecipeCategory;
import com.klikli_dev.occultism.integration.jei.impl.recipes.CrystallizeRecipeCategory;
import com.klikli_dev.occultism.integration.jei.impl.recipes.MinerRecipeCategory;
import com.klikli_dev.occultism.integration.jei.impl.recipes.RitualRecipeCategory;
import com.klikli_dev.occultism.integration.jei.impl.recipes.SpiritFireRecipeCategory;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    protected static IJeiRuntime runtime;

    public static IJeiRuntime getJeiRuntime() {
        return runtime;
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"jei");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new SpiritFireRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrushingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CrystallizeRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MinerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new RitualRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level = Minecraft.getInstance().level;
        RecipeManager recipeManager = level.getRecipeManager();
        registration.addRecipes(RecipeTypes.CRAFTING, BoundBookRecipeMaker.createRecipes());
        List spiritFireRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.SPIRIT_FIRE_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.SPIRIT_FIRE, spiritFireRecipes);
        List crushingRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.CRUSHING_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.CRUSHING, crushingRecipes);
        List crystallizeRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.CRYSTALLIZE_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.CRYSTALLIZE, crystallizeRecipes);
        List minerRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.MINER_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.MINER, minerRecipes);
        List ritualRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)OccultismRecipes.RITUAL_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.RITUAL, ritualRecipes);
        this.registerIngredientInfo(registration, (ItemLike)OccultismItems.TALLOW.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERSTONE.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_LOG.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_LEAVES.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_SAPLING.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.IESNIUM_ORE.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismBlocks.SPIRIT_FIRE.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismItems.DATURA.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismItems.SPAWN_EGG_GOAT_FAMILIAR.get());
        this.registerIngredientInfo(registration, (ItemLike)OccultismItems.SPAWN_EGG_SHUB_NIGGURATH_FAMILIAR.get());
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        IRecipeTransferHandlerHelper handlerHelper = registration.getTransferHelper();
        registration.addRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StorageControllerContainer>(StorageControllerContainer.class, handlerHelper), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StorageRemoteContainer>(StorageRemoteContainer.class, handlerHelper), RecipeTypes.CRAFTING);
        registration.addRecipeTransferHandler(new StorageControllerRecipeTransferHandler<StableWormholeContainer>(StableWormholeContainer.class, handlerHelper), RecipeTypes.CRAFTING);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.SPIRIT_FIRE.get()), new RecipeType[]{JeiRecipeTypes.SPIRIT_FIRE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.DIMENSIONAL_MINESHAFT.get()), new RecipeType[]{JeiRecipeTypes.MINER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get()), new RecipeType[]{JeiRecipeTypes.RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.DARK_GOLDEN_SACRIFICIAL_BOWL.get()), new RecipeType[]{JeiRecipeTypes.RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.IESNIUM_SACRIFICIAL_BOWL.get()), new RecipeType[]{JeiRecipeTypes.RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.DARK_IESNIUM_SACRIFICIAL_BOWL.get()), new RecipeType[]{JeiRecipeTypes.RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.CELESTIAL_CHALICE.get()), new RecipeType[]{JeiRecipeTypes.RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)OccultismBlocks.ELDRITCH_CHALICE.get()), new RecipeType[]{JeiRecipeTypes.RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_CRUSHER.getId())), new RecipeType[]{JeiRecipeTypes.CRUSHING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_CRUSHER.getId())), new RecipeType[]{JeiRecipeTypes.CRUSHING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_CRUSHER.getId())), new RecipeType[]{JeiRecipeTypes.CRUSHING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_MARID_CRUSHER.getId())), new RecipeType[]{JeiRecipeTypes.CRUSHING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_CRYSTALLIZER.getId())), new RecipeType[]{JeiRecipeTypes.CRYSTALLIZE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_CRYSTALLIZER.getId())), new RecipeType[]{JeiRecipeTypes.CRYSTALLIZE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_CRYSTALLIZER.getId())), new RecipeType[]{JeiRecipeTypes.CRYSTALLIZE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_MARID_CRYSTALLIZER.getId())), new RecipeType[]{JeiRecipeTypes.CRYSTALLIZE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_SMELTER.getId())), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_SMELTER.getId())), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_SMELTER.getId())), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_MARID_SMELTER.getId())), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_SMELTER.getId())), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_SMELTER.getId())), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_SMELTER.getId())), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_MARID_SMELTER.getId())), new RecipeType[]{RecipeTypes.SMOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_SMELTER.getId())), new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_SMELTER.getId())), new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_SMELTER.getId())), new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_MARID_SMELTER.getId())), new RecipeType[]{RecipeTypes.BLASTING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_FOLIOT_SMELTER.getId())), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_DJINNI_SMELTER.getId())), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_AFRIT_SMELTER.getId())), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(OccultismItems.RITUAL_DUMMY_SUMMON_MARID_SMELTER.getId())), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
    }

    public void registerIngredientInfo(IRecipeRegistration registration, ItemLike ingredient) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)ingredient.asItem()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("jei.occultism.ingredient." + BuiltInRegistries.ITEM.getKey((Object)ingredient.asItem()).getPath().replace("/", ".") + ".description"))});
    }
}

