/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipe;

import com.klikli_dev.occultism.datagen.recipe.builders.CrushingRecipeBuilder;
import com.klikli_dev.occultism.datagen.recipe.builders.CrystallizeRecipeBuilder;
import com.klikli_dev.occultism.datagen.recipe.builders.SpiritTradeRecipeBuilder;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public abstract class SpiritJobRecipes
extends RecipeProvider {
    public SpiritJobRecipes(PackOutput p_248933_, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(p_248933_, lookupProvider);
    }

    public static void spiritJobRecipes(RecipeOutput pRecipeOutput) {
        SpiritJobRecipes.spiritTradeRecipes(pRecipeOutput);
        SpiritJobRecipes.mobDropCrushing(pRecipeOutput);
        SpiritJobRecipes.oreProcessRecipes(pRecipeOutput);
        SpiritJobRecipes.blockProcessRecipes(pRecipeOutput);
    }

    private static void spiritTradeRecipes(RecipeOutput pRecipeOutput) {
        SpiritTradeRecipeBuilder.spiritTradeRecipe(Ingredient.of(OccultismTags.Items.OTHERWORLD_SAPLINGS_NATURAL), new ItemStack(OccultismBlocks.OTHERWORLD_SAPLING)).unlockedBy("has_otherworld_sapling_natural", SpiritJobRecipes.has((ItemLike)((ItemLike)OccultismBlocks.OTHERWORLD_SAPLING_NATURAL.get()))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_trade/otherworld_sapling"));
        SpiritTradeRecipeBuilder.spiritTradeRecipe(Ingredient.of((TagKey)Tags.Items.STONES), new ItemStack((ItemLike)OccultismBlocks.OTHERSTONE.get(), 2)).unlockedBy("has_stone", SpiritJobRecipes.has((TagKey)Tags.Items.STONES)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_trade/stone_to_otherstone"));
        SpiritTradeRecipeBuilder.spiritTradeRecipe(Ingredient.of((TagKey)Tags.Items.STONES), new ItemStack((ItemLike)OccultismBlocks.OTHERSTONE.get(), 4)).unlockedBy("has_stone", SpiritJobRecipes.has((TagKey)Tags.Items.STONES)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"spirit_trade/test"));
    }

    private static void mobDropCrushing(RecipeOutput pRecipeOutput) {
        CrushingRecipeBuilder.crushingRecipe((TagKey<Item>)Tags.Items.RODS_BLAZE, (ItemLike)Items.BLAZE_POWDER, 200).allowEmpty().setResultAmount(4).unlockedBy("has_blaze_rod", SpiritJobRecipes.has((TagKey)Tags.Items.RODS_BLAZE)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/blaze_powder_from_rod"));
        CrushingRecipeBuilder.crushingRecipe((TagKey<Item>)Tags.Items.RODS_BREEZE, (ItemLike)Items.WIND_CHARGE, 200).allowEmpty().setResultAmount(4).unlockedBy("has_breeze_rod", SpiritJobRecipes.has((TagKey)Tags.Items.RODS_BREEZE)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/wind_charge_from_rod"));
        CrushingRecipeBuilder.crushingRecipe((TagKey<Item>)Tags.Items.BONES, (ItemLike)Items.BONE_MEAL, 200).allowEmpty().setResultAmount(4).unlockedBy("has_bone", SpiritJobRecipes.has((TagKey)Tags.Items.BONES)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/bone_meal_from_bone"));
        CrushingRecipeBuilder.crushingRecipe((TagKey<Item>)Tags.Items.ENDER_PEARLS, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/ender_pearl")), 200).setAllowEmpty(false).setResultAmount(1).setIgnoreCrushingMultiplier(true).unlockedBy("has_ender_pearl", SpiritJobRecipes.has((TagKey)Tags.Items.ENDER_PEARLS)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/ender_pearl_dust_from_tag"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/ender_pearl")), (TagKey<Item>)Tags.Items.ENDER_PEARLS, 200).setAllowEmpty(false).setResultAmount(1).setMinTier(2).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_ender_pearl_dust", SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/ender_pearl")))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/ender_pearl"));
        CrushingRecipeBuilder.crushingRecipe(Items.ECHO_SHARD, OccultismTags.Items.ECHO_DUST, 200).allowEmpty().unlockedBy("has_echo_shard", SpiritJobRecipes.has((ItemLike)Items.ECHO_SHARD)).setResultAmount(1).setIgnoreCrushingMultiplier(true).setMinTier(4).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/echo_dust"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.Items.ECHO_DUST, (ItemLike)Items.ECHO_SHARD, 200).unlockedBy("has_echo_dust", SpiritJobRecipes.has(OccultismTags.Items.ECHO_DUST)).setResultAmount(1).setMinTier(4).setAllowEmpty(false).setIgnoreCrystallizeMultiplier(true).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/echo_shard"));
        CrystallizeRecipeBuilder.crystallizeRecipe(Items.PRISMARINE_SHARD, (ItemLike)Items.PRISMARINE_CRYSTALS, 200).unlockedBy("has_prismarine_shard", SpiritJobRecipes.has((ItemLike)Items.PRISMARINE_SHARD)).setResultAmount(1).setMinTier(2).setAllowEmpty(false).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/prismarine_crystal"));
    }

    private static void blockProcessRecipes(RecipeOutput pRecipeOutput) {
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.Items.OTHERSTONE, OccultismTags.Items.OTHERCOBBLESTONE, 20).unlockedBy("has_otherstone", SpiritJobRecipes.has(OccultismTags.Items.OTHERSTONE)).setAllowEmpty(false).setResultAmount(1).setIgnoreCrushingMultiplier(true).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/othercobblestone"));
        CrushingRecipeBuilder.crushingRecipe(OccultismBlocks.OTHERROCK.asItem(), (ItemLike)OccultismBlocks.OTHERCOBBLEROCK.asItem(), 20).unlockedBy("has_otherrock", SpiritJobRecipes.has((ItemLike)OccultismBlocks.OTHERROCK.asItem())).setAllowEmpty(false).setResultAmount(1).setIgnoreCrushingMultiplier(true).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/othercobblerock"));
        CrushingRecipeBuilder.crushingRecipe((TagKey<Item>)Tags.Items.OBSIDIANS, OccultismTags.Items.OBSIDIAN_DUST, 200).allowEmpty().setResultAmount(1).setIgnoreCrushingMultiplier(true).unlockedBy("has_obsidian", SpiritJobRecipes.has((TagKey)Tags.Items.OBSIDIANS)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/obsidian_dust"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.Items.OBSIDIAN_DUST, (ItemLike)Items.OBSIDIAN, 200).allowEmpty().setResultAmount(1).setMinTier(3).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_obsidian_dust", SpiritJobRecipes.has(OccultismTags.Items.OBSIDIAN_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/obsidian"));
        CrushingRecipeBuilder.crushingRecipe((TagKey<Item>)Tags.Items.END_STONES, OccultismTags.Items.END_STONE_DUST, 200).allowEmpty().setResultAmount(1).setIgnoreCrushingMultiplier(true).unlockedBy("has_end_stone", SpiritJobRecipes.has((TagKey)Tags.Items.END_STONES)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/end_stone_dust"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.Items.END_STONE_DUST, (ItemLike)Items.END_STONE, 200).allowEmpty().setResultAmount(1).setMinTier(3).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_end_stone_dust", SpiritJobRecipes.has(OccultismTags.Items.END_STONE_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/end_stone"));
        CrushingRecipeBuilder.crushingRecipe(Items.CALCITE, OccultismTags.Items.CALCITE_DUST, 200).allowEmpty().unlockedBy("has_calcite", SpiritJobRecipes.has((ItemLike)Items.CALCITE)).setResultAmount(1).setIgnoreCrushingMultiplier(true).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/calcite_dust"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.Items.CALCITE_DUST, (ItemLike)Items.CALCITE, 200).allowEmpty().setResultAmount(1).setMinTier(3).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_calcite_dust", SpiritJobRecipes.has(OccultismTags.Items.CALCITE_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/calcite"));
        CrushingRecipeBuilder.crushingRecipe(Items.BLACKSTONE, OccultismTags.Items.BLACKSTONE_DUST, 200).allowEmpty().unlockedBy("has_blackstone", SpiritJobRecipes.has((ItemLike)Items.BLACKSTONE)).setResultAmount(1).setIgnoreCrushingMultiplier(true).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/blackstone_dust"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.Items.BLACKSTONE_DUST, (ItemLike)Items.BLACKSTONE, 200).allowEmpty().setResultAmount(1).setMinTier(3).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_blackstone_dust", SpiritJobRecipes.has(OccultismTags.Items.BLACKSTONE_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/blackstone"));
        CrushingRecipeBuilder.crushingRecipe(Items.ICE, OccultismTags.Items.ICE_DUST, 200).allowEmpty().unlockedBy("has_ice", SpiritJobRecipes.has((ItemLike)Items.ICE)).setResultAmount(1).setIgnoreCrushingMultiplier(true).setMinTier(2).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/ice_dust"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.Items.ICE_DUST, (ItemLike)Items.ICE, 200).allowEmpty().setResultAmount(1).setMinTier(3).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_ice_dust", SpiritJobRecipes.has(OccultismTags.Items.ICE_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/ice"));
        CrushingRecipeBuilder.crushingRecipe(Items.PACKED_ICE, OccultismTags.Items.PACKED_ICE_DUST, 200).allowEmpty().unlockedBy("has_packed_ice", SpiritJobRecipes.has((ItemLike)Items.PACKED_ICE)).setResultAmount(1).setIgnoreCrushingMultiplier(true).setMinTier(2).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/packed_ice_dust"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.Items.PACKED_ICE_DUST, (ItemLike)Items.PACKED_ICE, 200).allowEmpty().setResultAmount(1).setMinTier(3).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_packed_ice_dust", SpiritJobRecipes.has(OccultismTags.Items.PACKED_ICE_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/packed_ice"));
        CrushingRecipeBuilder.crushingRecipe(Items.BLUE_ICE, OccultismTags.Items.BLUE_ICE_DUST, 200).allowEmpty().unlockedBy("has_blue_ice", SpiritJobRecipes.has((ItemLike)Items.BLUE_ICE)).setResultAmount(1).setIgnoreCrushingMultiplier(true).setMinTier(2).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/blue_ice_dust"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.Items.BLUE_ICE_DUST, (ItemLike)Items.BLUE_ICE, 200).allowEmpty().setResultAmount(1).setMinTier(3).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_blue_ice_dust", SpiritJobRecipes.has(OccultismTags.Items.BLUE_ICE_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/blue_ice"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.Items.OTHERSTONE_DUST, OccultismBlocks.OTHERSTONE, 200).allowEmpty().setResultAmount(1).setMinTier(3).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_otherstone_dust", SpiritJobRecipes.has(OccultismTags.Items.OTHERSTONE_DUST)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/otherstone"));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sky_stones")), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/sky_stone")), 200).unlockedBy("has_sky_stone", SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"sky_stones")))).setResultAmount(1).setAllowEmpty(false).setIgnoreCrushingMultiplier(true).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/sky_stone_dust"));
    }

    private static void oreProcessRecipes(RecipeOutput pRecipeOutput) {
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.Items.DATURA_CROP, OccultismTags.Items.DATURA_SEEDS, 200).unlockedBy("has_datura", SpiritJobRecipes.has(OccultismTags.Items.DATURA_CROP)).setAllowEmpty(false).setResultAmount(2).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/datura"));
        SpiritJobRecipes.fullMetalRecipe("copper", Items.COPPER_INGOT, pRecipeOutput);
        SpiritJobRecipes.fullMetalRecipe("iron", Items.IRON_INGOT, pRecipeOutput);
        SpiritJobRecipes.fullMetalRecipe("gold", Items.GOLD_INGOT, pRecipeOutput);
        SpiritJobRecipes.fullMetalRecipe("silver", (Item)OccultismItems.SILVER_INGOT.get(), pRecipeOutput);
        SpiritJobRecipes.fullMetalRecipe("iesnium", (Item)OccultismItems.IESNIUM_INGOT.get(), pRecipeOutput);
        SpiritJobRecipes.tripleCrushSmeltBlastRecipe("netherite", Items.NETHERITE_INGOT, pRecipeOutput);
        CrushingRecipeBuilder.crushingRecipe((TagKey<Item>)Tags.Items.ORES_NETHERITE_SCRAP, OccultismTags.Items.NETHERITE_SCRAP_DUST, 200).unlockedBy("has_ancient_debris", SpiritJobRecipes.has((TagKey)Tags.Items.ORES_NETHERITE_SCRAP)).setResultAmount(2).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/netherite_scrap_dust_from_ore"));
        CrushingRecipeBuilder.crushingRecipe(Items.NETHERITE_SCRAP, OccultismTags.Items.NETHERITE_SCRAP_DUST, 200).unlockedBy("has_netherite_scrap", SpiritJobRecipes.has((ItemLike)Items.NETHERITE_SCRAP)).setIgnoreCrushingMultiplier(true).setResultAmount(1).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/netherite_scrap_dust_from_scrap"));
        SpiritJobRecipes.doubleCookingRecipe("netherite_scrap", Items.NETHERITE_SCRAP, pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("aluminum", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("iridium", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("lead", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("nickel", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("osmium", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("platinum", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("tin", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("uranium", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("zinc", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("antimony", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("allthemodium", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("unobtainium", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("vibranium", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("crimson_iron", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("azure_silver", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("graphite", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("cobalt", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("titanium", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("tungsten", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("pewter", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("mithril", pRecipeOutput);
        SpiritJobRecipes.crushingMetalRecipe("quicksilver", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("adamant", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("azure_electrum", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("biosteel", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("blaze_gold", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("brass", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("bronze", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("constantan", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("crimson_steel", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("duratium", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("electrum", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("enderium", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("energite", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("hop_graphite", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("invar", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("lumium", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("refined_obsidian", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("steel", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("signalum", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("tyrian_steel", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("unobtainium_allthemodium_alloy", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("unobtainium_vibranium_alloy", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("vibranium_allthemodium_alloy", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("annealed_copper", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("battery_alloy", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("beryllium", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("cadmium", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("chromium", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("cupronickel", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("he_mox", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("he_uranium", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("kanthal", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("le_mox", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("le_uranium", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("plutonium", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("silicon", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("superconductor", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("uranium_235", pRecipeOutput);
        SpiritJobRecipes.crushingIngotRecipe("uranium_238", pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("dark_gem", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("diamond", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("emerald", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("lapis", 6, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("quartz", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("apatite", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("sulfur", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("fluorite", 4, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("cinnabar", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("amber", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("peridot", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("ruby", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("sapphire", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("topaz", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("arcane_crystal", 2, pRecipeOutput);
        SpiritJobRecipes.fullGemRecipe("black_quartz", 2, pRecipeOutput);
        SpiritJobRecipes.gemCrushCrystalRecipe("certus_quartz", pRecipeOutput);
        SpiritJobRecipes.gemCrushCrystalRecipe("fluix", pRecipeOutput);
        SpiritJobRecipes.gemCrushCrystalRecipe("amethyst", pRecipeOutput);
        SpiritJobRecipes.gemCrushCrystalRecipe("entro", pRecipeOutput);
        SpiritJobRecipes.crushingOreRecipe("coal", 2, pRecipeOutput);
        SpiritJobRecipes.crushingOreRecipe("redstone", 4, pRecipeOutput);
        SpiritJobRecipes.crushingOreRecipe("lignite_coal", 2, pRecipeOutput);
        SpiritJobRecipes.crushingOreRecipe("saltpeter", 2, pRecipeOutput);
        SpiritJobRecipes.crushingOreRecipe("monazite", 2, pRecipeOutput);
        SpiritJobRecipes.crushingOreRecipe("bauxite", 2, pRecipeOutput);
        SpiritJobRecipes.crushingOreRecipe("salt", 2, pRecipeOutput);
        CrushingRecipeBuilder.crushingRecipe(Items.COAL, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/coal")), 200).setAllowEmpty(false).setResultAmount(1).setIgnoreCrushingMultiplier(true).unlockedBy("has_coal", SpiritJobRecipes.has((ItemLike)Items.COAL)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/coal_dust_from_item"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/coal")), (ItemLike)Items.COAL, 200).setAllowEmpty(false).setResultAmount(1).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_coal_dust", SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/coal")))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/coal"));
        CrushingRecipeBuilder.crushingRecipe(Items.CHARCOAL, OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/charcoal")), 200).setAllowEmpty(false).setResultAmount(1).setIgnoreCrushingMultiplier(true).unlockedBy("has_charcoal", SpiritJobRecipes.has((ItemLike)Items.CHARCOAL)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/charcoal_dust_from_item"));
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/charcoal")), (ItemLike)Items.CHARCOAL, 200).setAllowEmpty(false).setResultAmount(1).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_charcoal_dust", SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/charcoal")))).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/charcoal"));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"coal_coke")), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/coal_coke")), 200).unlockedBy("has_coal_coke", SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"coal_coke")))).setResultAmount(1).setAllowEmpty(false).setIgnoreCrushingMultiplier(true).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/coal_coke_dust"));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"bricks/normal")), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/brick")), 200).unlockedBy("has_brick", SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"bricks/normal")))).setResultAmount(1).setAllowEmpty(false).setIgnoreCrushingMultiplier(true).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/brick_dust"));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"plates/carbon")), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"dusts/carbon")), 200).unlockedBy("has_carbon_plate", SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)"plates/carbon")))).setResultAmount(1).setAllowEmpty(false).setIgnoreCrushingMultiplier(true).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crushing/carbon_dust_from_plate"));
        CrystallizeRecipeBuilder.crystallizeRecipe(Items.AMETHYST_BLOCK, (ItemLike)Items.AMETHYST_SHARD, 200).allowEmpty().setResultAmount(4).setMinTier(2).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_amethyst_block", SpiritJobRecipes.has((ItemLike)Items.AMETHYST_BLOCK)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/amethyst_from_block"));
        CrystallizeRecipeBuilder.crystallizeRecipe(Items.QUARTZ_BLOCK, (ItemLike)Items.QUARTZ, 200).allowEmpty().setResultAmount(4).setMinTier(2).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_quartz_block", SpiritJobRecipes.has((ItemLike)Items.QUARTZ_BLOCK)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/quartz_from_block"));
        CrystallizeRecipeBuilder.crystallizeRecipe(Items.AMETHYST_CLUSTER, (ItemLike)Items.BUDDING_AMETHYST, 200).allowEmpty().setResultAmount(1).setMinTier(4).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_amethyst_cluster", SpiritJobRecipes.has((ItemLike)Items.AMETHYST_CLUSTER)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/budding_amethyst"));
        CrystallizeRecipeBuilder.crystallizeRecipe(Items.OBSIDIAN, (ItemLike)Items.CRYING_OBSIDIAN, 200).allowEmpty().setResultAmount(1).setMinTier(4).setIgnoreCrystallizeMultiplier(true).unlockedBy("has_obsidian", SpiritJobRecipes.has((ItemLike)Items.OBSIDIAN)).save(pRecipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"crystallize/crying_obsidian"));
    }

    protected static void crushingGeneralizedRecipe(String input, Integer amount, String from, Boolean mult, RecipeOutput recipeOutput) {
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)(from + "s/" + input))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + input))), 200).unlockedBy("has_" + input + "_" + from, SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)(from + "s/" + input))))).setResultAmount(amount).setAllowEmpty(false).setIgnoreCrushingMultiplier(mult).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crushing/" + input + "_dust_from_" + from)));
    }

    protected static void crushingOreRecipe(String input, Integer amount, RecipeOutput recipeOutput) {
        SpiritJobRecipes.crushingGeneralizedRecipe(input, amount, "ore", Boolean.FALSE, recipeOutput);
    }

    protected static void crushingIngotRecipe(String input, RecipeOutput recipeOutput) {
        SpiritJobRecipes.crushingGeneralizedRecipe(input, 1, "ingot", Boolean.TRUE, recipeOutput);
    }

    protected static void crushingGemRecipe(String input, RecipeOutput recipeOutput) {
        SpiritJobRecipes.crushingGeneralizedRecipe(input, 1, "gem", Boolean.TRUE, recipeOutput);
    }

    protected static void crystallizeGeneralizedRecipe(String input, Integer amount, String from, Boolean mult, RecipeOutput recipeOutput) {
        CrystallizeRecipeBuilder.crystallizeRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)(from + "s/" + input))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("gems/" + input))), 200).unlockedBy("has_" + input + "_" + from, SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)(from + "s/" + input))))).setResultAmount(amount).setAllowEmpty(false).setIgnoreCrystallizeMultiplier(mult).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crystallize/" + input + "_from_" + from)));
    }

    protected static void crystallizeDustRecipe(String input, RecipeOutput recipeOutput) {
        SpiritJobRecipes.crystallizeGeneralizedRecipe(input, 1, "dust", Boolean.TRUE, recipeOutput);
    }

    protected static void crystallizeOreRecipe(String input, Integer amount, RecipeOutput recipeOutput) {
        SpiritJobRecipes.crystallizeGeneralizedRecipe(input, amount, "ore", Boolean.FALSE, recipeOutput);
    }

    private static void doubleCookingRecipe(String metalName, Item output, RecipeOutput recipeOutput) {
        String outputString = output.toString().replace("minecraft:", "").replace("occultism:", "");
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + metalName)))), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.7f, (int)200).unlockedBy("has_" + metalName + "_dust", SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + metalName))))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("smelting/" + outputString + "_from_dust")));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + metalName)))), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.7f, (int)100).unlockedBy("has_" + metalName + "_dust", SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + metalName))))).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("blasting/" + outputString + "_from_dust")));
    }

    private static void gemCrushCrystalRecipe(String gemName, RecipeOutput recipeOutput) {
        SpiritJobRecipes.crushingGemRecipe(gemName, recipeOutput);
        SpiritJobRecipes.crystallizeDustRecipe(gemName, recipeOutput);
    }

    private static void fullGemRecipe(String gemName, Integer amount, RecipeOutput recipeOutput) {
        SpiritJobRecipes.crushingOreRecipe(gemName, (int)((double)amount.intValue() * 1.5), recipeOutput);
        SpiritJobRecipes.crystallizeOreRecipe(gemName, amount, recipeOutput);
        SpiritJobRecipes.crushingGemRecipe(gemName, recipeOutput);
        SpiritJobRecipes.crystallizeDustRecipe(gemName, recipeOutput);
    }

    private static void crushingMetalRecipe(String metalName, RecipeOutput recipeOutput) {
        SpiritJobRecipes.crushingIngotRecipe(metalName, recipeOutput);
        SpiritJobRecipes.crushingOreRecipe(metalName, 2, recipeOutput);
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("raw_materials/" + metalName))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + metalName))), 200).unlockedBy("has_raw_" + metalName, SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("raw_materials/" + metalName))))).setResultAmount(2).setAllowEmpty(false).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crushing/" + metalName + "_dust_from_raw")));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/raw_" + metalName))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dusts/" + metalName))), 1600).unlockedBy("has_raw_" + metalName + "_block", SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("storage_blocks/raw_" + metalName))))).setResultAmount(18).setAllowEmpty(false).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crushing/" + metalName + "_dust_from_raw_block")));
        CrushingRecipeBuilder.crushingRecipe(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("clumps/" + metalName))), OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dirty_dusts/" + metalName))), 200).unlockedBy("has_clump_" + metalName, SpiritJobRecipes.has(OccultismTags.makeItemTag(ResourceLocation.fromNamespaceAndPath((String)"c", (String)("clumps/" + metalName))))).setResultAmount(2).setAllowEmpty(false).save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)("crushing/" + metalName + "_dirty_dust_from_clump")));
    }

    private static void fullMetalRecipe(String metalName, Item ingot, RecipeOutput recipeOutput) {
        SpiritJobRecipes.crushingMetalRecipe(metalName, recipeOutput);
        SpiritJobRecipes.doubleCookingRecipe(metalName, ingot, recipeOutput);
    }

    private static void tripleCrushSmeltBlastRecipe(String input, Item output, RecipeOutput recipeOutput) {
        SpiritJobRecipes.crushingIngotRecipe(input, recipeOutput);
        SpiritJobRecipes.doubleCookingRecipe(input, output, recipeOutput);
    }
}

