/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe.result;

import com.klikli_dev.occultism.crafting.recipe.result.RecipeResultType;
import com.klikli_dev.occultism.crafting.recipe.result.WeightedRecipeResult;
import com.klikli_dev.occultism.registry.OccultismRecipeResults;
import com.klikli_dev.occultism.util.TagUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public class WeightedTagRecipeResult
extends WeightedRecipeResult {
    public static final MapCodec<WeightedTagRecipeResult> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(t -> t.tag), (App)Codec.INT.fieldOf("count").forGetter(t -> t.count), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(t -> t.patch), (App)Codec.INT.fieldOf("weight").forGetter(WeightedRecipeResult::weight)).apply((Applicative)builder, WeightedTagRecipeResult::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WeightedTagRecipeResult> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)TagKey.codec((ResourceKey)Registries.ITEM)), t -> t.tag, (StreamCodec)ByteBufCodecs.INT, t -> t.count, (StreamCodec)DataComponentPatch.STREAM_CODEC, t -> t.patch, (StreamCodec)ByteBufCodecs.INT, WeightedRecipeResult::weight, WeightedTagRecipeResult::new);
    private final TagKey<Item> tag;
    private final int count;
    private final DataComponentPatch patch;
    @Nullable
    protected ItemStack cachedOutputStack;
    @Nullable
    private ItemStack[] cachedStacks;

    public WeightedTagRecipeResult(TagKey<Item> tag, int count, int weight) {
        this(tag, count, DataComponentPatch.EMPTY, weight);
    }

    public WeightedTagRecipeResult(TagKey<Item> tag, int count, DataComponentPatch patch, int weight) {
        super(weight);
        this.tag = tag;
        this.count = count;
        this.patch = patch;
    }

    public TagKey<Item> tag() {
        return this.tag;
    }

    public int count() {
        return this.count;
    }

    public DataComponentPatch patch() {
        return this.patch;
    }

    @Override
    public ItemStack getStack() {
        if (this.cachedOutputStack == null) {
            ItemStack item = TagUtil.getItemStackForTag(this.tag).copy();
            item.setCount(this.count);
            item.applyComponents(this.patch);
            if (item.isEmpty()) {
                item = new ItemStack((ItemLike)Blocks.BARRIER);
                item.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Empty Tag: " + String.valueOf(this.tag.location()))));
            }
            this.cachedOutputStack = item;
        }
        return this.cachedOutputStack;
    }

    @Override
    public ItemStack[] getStacks() {
        if (this.cachedStacks == null) {
            this.cachedStacks = BuiltInRegistries.ITEM.getTag(this.tag).map(tag -> (ItemStack[])tag.stream().map(ItemStack::new).toArray(ItemStack[]::new)).orElse(new ItemStack[0]);
        }
        return this.cachedStacks;
    }

    @Override
    public RecipeResultType<?> getType() {
        return (RecipeResultType)OccultismRecipeResults.WEIGHTED_TAG.get();
    }

    @Override
    public WeightedTagRecipeResult copyWithCount(int count) {
        return new WeightedTagRecipeResult(this.tag, count, this.patch, this.weight.asInt());
    }

    @Override
    public WeightedTagRecipeResult copyWithWeight(int weight) {
        return new WeightedTagRecipeResult(this.tag, this.count, this.patch, weight);
    }
}

