/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.crafting.recipe;

import com.klikli_dev.occultism.crafting.recipe.SingleInputRecipe;
import com.klikli_dev.occultism.crafting.recipe.TieredSingleRecipeInput;
import com.klikli_dev.occultism.crafting.recipe.result.RecipeResult;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CrushingRecipe
extends SingleInputRecipe<TieredSingleRecipeInput> {
    public static final StreamCodec<RegistryFriendlyByteBuf, CrushingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.input, RecipeResult.STREAM_CODEC, r -> r.result, (StreamCodec)ByteBufCodecs.INT, r -> r.minTier, (StreamCodec)ByteBufCodecs.INT, r -> r.maxTier, (StreamCodec)ByteBufCodecs.INT, r -> r.crushingTime, (StreamCodec)ByteBufCodecs.BOOL, r -> r.ignoreCrushingMultiplier, CrushingRecipe::new);
    public static int DEFAULT_CRUSHING_TIME = 200;
    public static final MapCodec<CrushingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> r.input), (App)RecipeResult.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.INT.optionalFieldOf("min_tier", (Object)-1).forGetter(r -> r.minTier), (App)Codec.INT.optionalFieldOf("max_tier", (Object)-1).forGetter(r -> r.maxTier), (App)Codec.INT.optionalFieldOf("crushing_time", (Object)DEFAULT_CRUSHING_TIME).forGetter(r -> r.crushingTime), (App)Codec.BOOL.optionalFieldOf("ignore_crushing_multiplier", (Object)false).forGetter(r -> r.ignoreCrushingMultiplier)).apply((Applicative)instance, CrushingRecipe::new));
    public static Serializer SERIALIZER = new Serializer();
    protected final int crushingTime;
    protected final int minTier;
    protected final int maxTier;
    protected final boolean ignoreCrushingMultiplier;
    protected RecipeResult result;

    public CrushingRecipe(Ingredient input, RecipeResult result, int minTier, int maxTier, int crushingTime, boolean ignoreCrushingMultiplier) {
        super(input, ItemStack.EMPTY);
        this.result = result;
        this.crushingTime = crushingTime;
        this.minTier = minTier;
        this.maxTier = maxTier;
        this.ignoreCrushingMultiplier = ignoreCrushingMultiplier;
    }

    public boolean isSpecial() {
        return true;
    }

    public int getCrushingTime() {
        return this.crushingTime;
    }

    public boolean getIgnoreCrushingMultiplier() {
        return this.ignoreCrushingMultiplier;
    }

    public int getMinTier() {
        return this.minTier;
    }

    public int getMaxTier() {
        return this.maxTier;
    }

    @Override
    public boolean matches(TieredSingleRecipeInput inv, Level level) {
        boolean tierMatches = true;
        if (this.minTier >= 0 && this.maxTier >= 0) {
            tierMatches = inv.tier() >= this.minTier && inv.tier() <= this.maxTier;
        } else if (this.minTier >= 0) {
            tierMatches = inv.tier() >= this.minTier;
        } else if (this.maxTier >= 0) {
            tierMatches = inv.tier() <= this.maxTier;
        }
        return tierMatches && this.input.test(inv.getItem(0));
    }

    @Override
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return this.result.getStack();
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public RecipeType<?> getType() {
        return (RecipeType)OccultismRecipes.CRUSHING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<CrushingRecipe> {
        public MapCodec<CrushingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CrushingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

