/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.config;

import net.neoforged.neoforge.common.ModConfigSpec;

public class OccultismClientConfig {
    public final VisualSettings visuals;
    public final MiscSettings misc;
    public final ModConfigSpec spec;

    public OccultismClientConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.visuals = new VisualSettings(builder);
        this.misc = new MiscSettings(builder);
        this.spec = builder.build();
    }

    public static class VisualSettings {
        public final ModConfigSpec.BooleanValue showItemTagsInTooltip;
        public final ModConfigSpec.BooleanValue disableDemonsDreamShaders;
        public final ModConfigSpec.BooleanValue disableHolidayTheming;
        public final ModConfigSpec.BooleanValue useAlternativeDivinationRodRenderer;
        public final ModConfigSpec.IntValue whiteChalkGlyphColor;
        public final ModConfigSpec.IntValue yellowChalkGlyphColor;
        public final ModConfigSpec.IntValue purpleChalkGlyphColor;
        public final ModConfigSpec.IntValue redChalkGlyphColor;
        public final ModConfigSpec.IntValue lightGrayChalkGlyphColor;
        public final ModConfigSpec.IntValue grayChalkGlyphColor;
        public final ModConfigSpec.IntValue blackChalkGlyphColor;
        public final ModConfigSpec.IntValue brownChalkGlyphColor;
        public final ModConfigSpec.IntValue orangeChalkGlyphColor;
        public final ModConfigSpec.IntValue limeChalkGlyphColor;
        public final ModConfigSpec.IntValue greenChalkGlyphColor;
        public final ModConfigSpec.IntValue cyanChalkGlyphColor;
        public final ModConfigSpec.IntValue lightBlueChalkGlyphColor;
        public final ModConfigSpec.IntValue blueChalkGlyphColor;
        public final ModConfigSpec.IntValue magentaChalkGlyphColor;
        public final ModConfigSpec.IntValue pinkChalkGlyphColor;

        public VisualSettings(ModConfigSpec.Builder builder) {
            builder.comment("Visual Settings").push("visual");
            this.showItemTagsInTooltip = builder.comment("Shows all tags an item has in the tooltip on hover if advanced tooltips (F3+H) are enabled.").define("showItemTagsInTooltip", false);
            this.disableDemonsDreamShaders = builder.comment("Disables the headache- and possibly seizure-inducing visual effects of Demon's Dream.").define("disableDemonsDreamShaders", false);
            this.disableHolidayTheming = builder.comment("Disables holiday themed visual content such as familiar skins.").define("disableHolidayTheming", false);
            this.useAlternativeDivinationRodRenderer = builder.comment(new String[]{"When true the old divination rod selected block renderer will be used.", "May work for some people that do not see selected block outlines when using the divination rod."}).define("useAlternativeDivinationRodRenderer", false);
            this.whiteChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the white chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("whiteChalkGlyphColor", 0xFFFFFF, 0, 0xFFFFFF);
            this.lightGrayChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the light gray chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("lightGrayChalkGlyphColor", 0x9D9D97, 0, 0xFFFFFF);
            this.grayChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the gray chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("grayChalkGlyphColor", 4673362, 0, 0xFFFFFF);
            this.blackChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the black chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("blackChalkGlyphColor", 0x1D1D21, 0, 0xFFFFFF);
            this.brownChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the brown chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("brownChalkGlyphColor", 8606770, 0, 0xFFFFFF);
            this.redChalkGlyphColor = builder.comment(new String[]{"The integer code of the  color of the red chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness this value should be changed to a green color, we recommend 33289 (= Hex 0x008209)"}).defineInRange("redChalkGlyphColor", 0xCC0101, 0, 0xFFFFFF);
            this.orangeChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the orange chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("orangeChalkGlyphColor", 16351261, 0, 0xFFFFFF);
            this.yellowChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the yellow chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("yellowChalkGlyphColor", 15783680, 0, 0xFFFFFF);
            this.limeChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the lime chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("limeChalkGlyphColor", 8439583, 0, 0xFFFFFF);
            this.greenChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the green chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("greenChalkGlyphColor", 6192150, 0, 0xFFFFFF);
            this.cyanChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the cyan chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("cyanChalkGlyphColor", 1481884, 0, 0xFFFFFF);
            this.lightBlueChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the light blue chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("lightBlueChalkGlyphColor", 8432615, 0, 0xFFFFFF);
            this.blueChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the blue chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("blueChalkGlyphColor", 3949738, 0, 0xFFFFFF);
            this.purpleChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the purple chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("purpleChalkGlyphColor", 10224531, 0, 0xFFFFFF);
            this.magentaChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the magenta chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("magentaChalkGlyphColor", 13061821, 0, 0xFFFFFF);
            this.pinkChalkGlyphColor = builder.comment(new String[]{"The integer code of the color of the pink chalk glyph in world.", "This is intended to allow people with color blindness to change the color of the glyph.", "For most types of color blindness it should not be necessary to change this."}).defineInRange("pinkChalkGlyphColor", 15961002, 0, 0xFFFFFF);
            builder.pop();
        }
    }

    public static class MiscSettings {
        public final ModConfigSpec.BooleanValue syncJeiSearch;
        public final ModConfigSpec.BooleanValue enableEMISync;
        public final ModConfigSpec.BooleanValue divinationRodHighlightAllResults;
        public final ModConfigSpec.IntValue divinationRodScanRange;
        public final ModConfigSpec.BooleanValue disableSpiritFireSuccessSound;
        public final ModConfigSpec.IntValue pentagramInBowlInfoCount;
        public final ModConfigSpec.IntValue pentagramInBowlInfoTicks;

        public MiscSettings(ModConfigSpec.Builder builder) {
            builder.comment("Misc Settings").push("misc");
            this.syncJeiSearch = builder.comment("Sync JEI search in storage actuator.").define("syncJeiSearch", false);
            this.enableEMISync = builder.comment("Enables EMI sync for the storage actuator.").define("enableEMISync", true);
            this.divinationRodHighlightAllResults = builder.comment(new String[]{"If true, divination rod will render all matching blocks with an outline. Disable if it causes lag.", "This setting will be unused, if Theurgy is installed alongside, as Occultism will use Theurgy's divination rod result rendering instead."}).define("divinationRodHighlightAllResults", false);
            this.divinationRodScanRange = builder.comment("The scan range in blocks for the divination rod. Too high might cause lags").defineInRange("divinationRodScanRange", 129, 1, Integer.MAX_VALUE);
            this.disableSpiritFireSuccessSound = builder.comment("Disables the sound played when a spirit fire successfully crafted an item.").define("disableSpiritFireSuccessSound", false);
            this.pentagramInBowlInfoCount = builder.comment("How many pentagrams to show at one time on the bowl information").defineInRange("pentagramInBowlInfoCount", 3, 1, Integer.MAX_VALUE);
            this.pentagramInBowlInfoTicks = builder.comment("How many ticks between each page for the pentagram information on a bowl").defineInRange("pentagramInBowlInfoTicks", 40, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

