/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.misc;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.misc.IMapItemHandlerModifiable;
import com.klikli_dev.occultism.common.misc.ItemStackKey;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class MapItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
IMapItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    protected static final int VIRTUAL_SLOT = -1;
    private static final Codec<Map<ItemStackKey, Integer>> MAP_CODEC = Codec.list((Codec)Codec.pair((Codec)ItemStackKey.CODEC.fieldOf("itemStackkey").codec(), (Codec)Codec.INT.fieldOf("int").codec())).xmap(list -> list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(e -> Pair.of((Object)((ItemStackKey)e.getKey()), (Object)((Integer)e.getValue()))).collect(Collectors.toList()));
    public static final Codec<MapItemStackHandler> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MAP_CODEC.fieldOf("keyToCountMap").forGetter(handler -> handler.keyToCountMap), (App)MAP_CODEC.fieldOf("keyToSlot").forGetter(handler -> handler.keyToSlot), (App)Codec.INT.listOf().fieldOf("emptySlots").forGetter(handler -> handler.emptySlots), (App)Codec.INT.fieldOf("nextSlot").forGetter(handler -> handler.nextSlotIndex), (App)Codec.INT.fieldOf("maxSlots").forGetter(handler -> handler.maxItemTypes), (App)Codec.LONG.fieldOf("totalItemCount").forGetter(handler -> handler.totalItemCount), (App)Codec.LONG.fieldOf("maxTotalItemCount").forGetter(handler -> handler.maxTotalItemCount)).apply((Applicative)instance, (keyToCountMap, keyToSlot, emptySlots, nextSlot, maxSlots, totalItemCount, maxTotalItemCount) -> new MapItemStackHandler((Object2IntOpenHashMap<ItemStackKey>)new Object2IntOpenHashMap(keyToCountMap), (BiMap<ItemStackKey, Integer>)HashBiMap.create((Map)keyToSlot), emptySlots.stream().collect(Collectors.toCollection(Stack::new)), (int)nextSlot, (int)maxSlots, (long)totalItemCount, (long)maxTotalItemCount)));
    protected Object2IntOpenHashMap<ItemStackKey> keyToCountMap;
    protected Multimap<Item, ItemStackKey> itemToVariantsCache = HashMultimap.create();
    protected BiMap<ItemStackKey, Integer> keyToSlot;
    protected Stack<Integer> emptySlots;
    protected int nextSlotIndex;
    protected int maxItemTypes;
    protected long totalItemCount;
    protected long maxTotalItemCount;

    public MapItemStackHandler() {
        this(-1, -1L);
    }

    public MapItemStackHandler(int maxItemTypes, long maxTotalItemCount) {
        this((Object2IntOpenHashMap<ItemStackKey>)new Object2IntOpenHashMap(), (BiMap<ItemStackKey, Integer>)HashBiMap.create(), new Stack<Integer>(), 0, maxItemTypes, 0L, maxTotalItemCount);
    }

    public MapItemStackHandler(Object2IntOpenHashMap<ItemStackKey> keyToCountMap, BiMap<ItemStackKey, Integer> keyToSlot, Stack<Integer> emptySlots, int nextSlotIndex, int maxItemTypes, long totalItemCount, long maxTotalItemCount) {
        this.keyToCountMap = keyToCountMap;
        this.keyToSlot = keyToSlot;
        this.emptySlots = emptySlots;
        this.nextSlotIndex = nextSlotIndex;
        this.maxItemTypes = maxItemTypes;
        this.totalItemCount = totalItemCount;
        this.maxTotalItemCount = maxTotalItemCount;
    }

    public Object2IntOpenHashMap<ItemStackKey> keyToCountMap() {
        return this.keyToCountMap;
    }

    public long totalItemCount() {
        return this.totalItemCount;
    }

    public int maxItemTypes() {
        return this.maxItemTypes;
    }

    public boolean hasMaxItemTypes() {
        return this.maxItemTypes != -1;
    }

    public void maxItemTypes(int maxItemTypes) {
        this.maxItemTypes = maxItemTypes;
    }

    public long maxTotalItemCount() {
        return this.maxTotalItemCount;
    }

    public void maxTotalItemCount(long maxTotalItemCount) {
        this.maxTotalItemCount = maxTotalItemCount;
    }

    @Override
    public int get(ItemStack stack) {
        return this.get(ItemStackKey.of(stack));
    }

    @Override
    public int get(ItemStackKey key) {
        return this.keyToCountMap.getOrDefault((Object)key, 0);
    }

    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ListTag keyToCountList = new ListTag();
        this.keyToCountMap.forEach((key, value) -> {
            try {
                CompoundTag entryTag = new CompoundTag();
                entryTag.put("itemStackkey", key.stack().save(provider, (Tag)new CompoundTag()));
                entryTag.putInt("int", value.intValue());
                keyToCountList.add((Object)entryTag);
            }
            catch (Exception e) {
                Occultism.LOGGER.error("Failed to serialize ItemStackKey: " + String.valueOf(key));
            }
        });
        nbt.put("keyToCountMap", (Tag)keyToCountList);
        ListTag keyToSlotList = new ListTag();
        this.keyToSlot.forEach((key, slot) -> {
            try {
                CompoundTag entryTag = new CompoundTag();
                entryTag.put("itemStackkey", key.stack().save(provider, (Tag)new CompoundTag()));
                entryTag.putInt("int", slot.intValue());
                keyToSlotList.add((Object)entryTag);
            }
            catch (Exception e) {
                Occultism.LOGGER.error("Failed to serialize ItemStackKey: " + String.valueOf(key));
            }
        });
        nbt.put("keyToSlot", (Tag)keyToSlotList);
        nbt.putIntArray("emptySlots", new ArrayList<Integer>(this.emptySlots));
        nbt.putInt("nextSlot", this.nextSlotIndex);
        nbt.putInt("maxSlots", this.maxItemTypes);
        nbt.putLong("totalItemCount", this.totalItemCount);
        nbt.putLong("maxTotalItemCount", this.maxTotalItemCount);
        return nbt;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        ListTag keyToCountList = nbt.getList("keyToCountMap", 10);
        this.keyToCountMap = new Object2IntOpenHashMap();
        keyToCountList.forEach(tag -> {
            CompoundTag entryTag = (CompoundTag)tag;
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)entryTag.getCompound("itemStackkey"));
            if (stack.isEmpty()) {
                return;
            }
            ItemStackKey key = new ItemStackKey(stack);
            int count = entryTag.getInt("int");
            this.keyToCountMap.put((Object)key, count);
        });
        ListTag keyToSlotList = nbt.getList("keyToSlot", 10);
        this.keyToSlot = HashBiMap.create();
        keyToSlotList.forEach(tag -> {
            CompoundTag entryTag = (CompoundTag)tag;
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)entryTag.getCompound("itemStackkey"));
            if (stack.isEmpty()) {
                return;
            }
            ItemStackKey key = new ItemStackKey(stack);
            int slot = entryTag.getInt("int");
            this.keyToSlot.put((Object)key, (Object)slot);
        });
        this.emptySlots = Arrays.stream(nbt.getIntArray("emptySlots")).boxed().collect(Collectors.toCollection(Stack::new));
        this.nextSlotIndex = nbt.getInt("nextSlot");
        this.maxItemTypes = nbt.getInt("maxSlots");
        this.totalItemCount = nbt.getLong("totalItemCount");
        this.maxTotalItemCount = nbt.getLong("maxTotalItemCount");
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        ItemStackKey key = ItemStackKey.of(stack);
        Integer existingSlot = (Integer)this.keyToSlot.get((Object)key);
        if (existingSlot != null && existingSlot != slot) {
            return;
        }
        if (existingSlot == null && this.keyToSlot.inverse().get((Object)slot) == null && slot < this.nextSlotIndex && !stack.isEmpty()) {
            this.keyToSlot.put((Object)key, (Object)slot);
            this.emptySlots.remove((Object)slot);
            this.keyToCountMap.put((Object)key, stack.getCount());
            this.totalItemCount += (long)stack.getCount();
            this.onContentsChanged(key);
        } else if (existingSlot != null && existingSlot == slot) {
            int existing = this.keyToCountMap.getOrDefault((Object)key, 0);
            this.totalItemCount -= (long)existing;
            if (stack.isEmpty()) {
                this.keyToCountMap.removeInt((Object)key);
                this.removeFromSlots(key);
            } else {
                this.keyToCountMap.put((Object)key, stack.getCount());
                this.totalItemCount += (long)stack.getCount();
            }
            this.onContentsChanged(key);
        }
    }

    public int getSlots() {
        if (!this.hasMaxItemTypes()) {
            return this.nextSlotIndex + 1;
        }
        return Math.min(this.maxItemTypes, this.nextSlotIndex + 1);
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStackKey key = (ItemStackKey)this.keyToSlot.inverse().get((Object)slot);
        int count = this.keyToCountMap.getOrDefault((Object)key, 0);
        return key != null ? key.stack().copyWithCount(count) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.insertItem(stack, simulate);
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStackKey key = ItemStackKey.of(stack);
        if (!this.isItemValid(-1, key)) {
            return stack;
        }
        int existing = this.keyToCountMap.getOrDefault((Object)key, 0);
        int limit = this.getStackLimit(stack);
        if (existing > 0) {
            limit -= existing;
        }
        if (existing == 0 && this.maxItemTypes != -1 && this.keyToCountMap.size() >= this.maxItemTypes) {
            return stack;
        }
        if ((limit = Math.min(limit, Math.toIntExact(this.maxTotalItemCount - this.totalItemCount))) <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing <= 0) {
                this.keyToCountMap.put((Object)key, reachedLimit ? limit : stack.getCount());
                this.addToSlots(key);
            } else {
                this.keyToCountMap.put((Object)key, existing + (reachedLimit ? limit : stack.getCount()));
            }
            this.totalItemCount += reachedLimit ? (long)limit : (long)stack.getCount();
            this.onContentsChanged(key);
        }
        return reachedLimit ? stack.copyWithCount(stack.getCount() - limit) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        ItemStackKey key = (ItemStackKey)this.keyToSlot.inverse().get((Object)slot);
        if (key == null) {
            return ItemStack.EMPTY;
        }
        return this.extractItem(key, amount, simulate);
    }

    @Override
    @NotNull
    public ItemStack extractItem(@NotNull ItemStackKey key, int amount, boolean simulate) {
        int existing = this.keyToCountMap.getInt((Object)key);
        if (existing <= 0) {
            return ItemStack.EMPTY;
        }
        int toExtract = amount;
        if (existing <= toExtract) {
            if (!simulate) {
                this.keyToCountMap.removeInt((Object)key);
                this.totalItemCount -= (long)existing;
                this.removeFromSlots(key);
                this.onContentsChanged(key);
                return key.stack().copyWithCount(existing);
            }
            return key.stack().copyWithCount(existing);
        }
        if (!simulate) {
            this.keyToCountMap.put((Object)key, existing - toExtract);
            this.totalItemCount -= (long)toExtract;
            this.onContentsChanged(key);
        }
        return key.stack().copyWithCount(toExtract);
    }

    @Override
    @NotNull
    public ItemStack extractItem(@NotNull ItemStack stack, int amount, boolean simulate) {
        ItemStackKey key = ItemStackKey.of(stack);
        return this.extractItem(key, amount, simulate);
    }

    @Override
    @NotNull
    public ItemStack extractItemIgnoreComponents(@NotNull ItemStack stack, int amount, boolean simulate) {
        Item item = stack.getItem();
        if (!this.itemToVariantsCache.containsKey((Object)item)) {
            this.buildItemToVariantsCacheFor(item);
        }
        Collection variants = this.itemToVariantsCache.get((Object)item);
        for (ItemStackKey key : variants) {
            ItemStack extracted = this.extractItem(key, amount, true);
            if (extracted.isEmpty()) continue;
            return this.extractItem(key, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    protected void buildItemToVariantsCacheFor(Item item) {
        this.keyToCountMap.keySet().stream().filter(key -> key.stack().getItem() == item).forEach(key -> this.itemToVariantsCache.put((Object)item, key));
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.isItemValid(slot, ItemStackKey.of(stack));
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStackKey key) {
        return true;
    }

    protected void addToSlots(ItemStackKey key) {
        if (!this.emptySlots.empty()) {
            Integer index = this.emptySlots.pop();
            this.keyToSlot.put((Object)key, (Object)index);
        } else {
            this.keyToSlot.put((Object)key, (Object)this.nextSlotIndex++);
        }
        if (this.itemToVariantsCache.containsKey((Object)key.stack().getItem())) {
            this.itemToVariantsCache.put((Object)key.stack().getItem(), (Object)key);
        }
    }

    protected void removeFromSlots(ItemStackKey key) {
        Integer index = (Integer)this.keyToSlot.get((Object)key);
        if (index != null) {
            this.keyToSlot.remove((Object)key);
            this.emptySlots.push(index);
        }
        this.itemToVariantsCache.remove((Object)key.stack().getItem(), (Object)key);
    }

    protected int getStackLimit(@NotNull ItemStack stack) {
        return this.getSlotLimit(-1);
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || !this.fitsInMaxSlots(slot)) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + (this.maxItemTypes != -1 ? this.maxItemTypes : Integer.MAX_VALUE) + ")");
        }
    }

    protected boolean fitsInMaxSlots(int slot) {
        return this.hasMaxItemTypes() && slot < this.maxItemTypes;
    }

    protected void onContentsChanged(ItemStackKey key) {
    }
}

