/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismTags;
import com.klikli_dev.occultism.util.ItemNBTUtil;
import com.klikli_dev.occultism.util.TextUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VitalityCompassItem
extends Item {
    private final CompassWobble wobbleRandom = new CompassWobble();
    public static final float NOT_FOUND = 0.0f;

    public VitalityCompassItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        if (!target.isAlive()) {
            return InteractionResult.PASS;
        }
        if (target.level().isClientSide) {
            return InteractionResult.PASS;
        }
        if (target.getType().is(OccultismTags.Entities.VITALITY_COMPASS_DENY_LIST)) {
            player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.target_blocked"), (Object[])new Object[]{target.getName()}), true);
            return InteractionResult.FAIL;
        }
        ItemNBTUtil.setSpiritEntityUUID(stack, target.getUUID());
        ItemNBTUtil.setBoundSpiritName(stack, target.getName().getString());
        player.displayClientMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.target_linked"), (Object[])new Object[]{target.getName()}), true);
        player.swing(hand);
        player.setItemInHand(hand, stack);
        player.inventoryMenu.broadcastChanges();
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip"), (Object[])new Object[]{TextUtil.formatDemonName(ItemNBTUtil.getBoundSpiritName(pStack))}));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (stack.has(OccultismDataComponents.SPIRIT_ENTITY_UUID)) {
                Entity target = serverlevel.getEntity((UUID)stack.get(OccultismDataComponents.SPIRIT_ENTITY_UUID));
                if (target != null && target.level().dimension() == entity.level().dimension()) {
                    stack.set(OccultismDataComponents.COMPASS_ANGLE, (Object)Float.valueOf(this.getRotationTowardsCompassTarget(entity, target.blockPosition())));
                } else {
                    stack.set(OccultismDataComponents.COMPASS_ANGLE, (Object)Float.valueOf(this.getRandomlySpinningRotation(entity.getId(), level.getGameTime())));
                }
            } else {
                stack.set(OccultismDataComponents.COMPASS_ANGLE, (Object)Float.valueOf(this.getRandomlySpinningRotation(entity.getId(), level.getGameTime())));
            }
        }
    }

    private float getRotationTowardsCompassTarget(Entity entity, BlockPos pos) {
        Player player;
        double d0 = this.getAngleFromEntityToPos(entity, pos);
        double d1 = this.getWrappedVisualRotationY(entity);
        if (entity instanceof Player && (player = (Player)entity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            return Mth.positiveModulo((float)((float)d0), (float)1.0f);
        }
        double d2 = 0.5 - (d1 - 0.25 - d0);
        return Mth.positiveModulo((float)((float)d2), (float)1.0f);
    }

    private double getAngleFromEntityToPos(Entity entity, BlockPos pos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        return Math.atan2(vec3.z() - entity.getZ(), vec3.x() - entity.getX()) / 6.2831854820251465;
    }

    private double getWrappedVisualRotationY(Entity entity) {
        double d;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            d = Mth.positiveModulo((double)(player.getYHeadRot() / 360.0f), (double)1.0);
        } else {
            d = Mth.positiveModulo((double)(entity.getVisualRotationYInDegrees() / 360.0f), (double)1.0);
        }
        return d;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    private float getRandomlySpinningRotation(int seed, long ticks) {
        if (this.wobbleRandom.shouldUpdate(ticks)) {
            this.wobbleRandom.update(ticks, Math.random());
        }
        double d0 = this.wobbleRandom.rotation + (double)((float)this.hash(seed) / 2.1474836E9f);
        return Mth.positiveModulo((float)((float)d0), (float)1.0f);
    }

    private int hash(int value) {
        return value * 1327217883;
    }

    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long ticks) {
            return this.lastUpdateTick != ticks;
        }

        void update(long ticks, double rotation) {
            this.lastUpdateTick = ticks;
            double d0 = rotation - this.rotation;
            d0 = Mth.positiveModulo((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.positiveModulo((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }
}

