/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.tool;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class DamageInCraftingItem
extends Item {
    public DamageInCraftingItem(Item.Properties properties) {
        super(properties);
        this.craftingRemainingItem = this;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        DataComponentMap components = itemStack.getComponents();
        boolean[] eternal = new boolean[]{false};
        components.forEach(comp -> {
            if (comp.toString().startsWith("forbidden_arcanus:modifier") && comp.toString().contains("eternal")) {
                eternal[0] = true;
            }
        });
        if (eternal[0] || !itemStack.isDamageableItem()) {
            return itemStack.copy();
        }
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
        int unbLvl = 0;
        for (Map.Entry e : enchantments.entrySet()) {
            if (!((Holder)e.getKey()).is(Enchantments.UNBREAKING)) continue;
            unbLvl = (Integer)e.getValue();
        }
        ItemStack remain = itemStack.copy();
        if (RandomSource.create().nextFloat() <= 1.0f / (float)(unbLvl + 1)) {
            remain.setDamageValue(itemStack.getDamageValue() + 1);
        }
        return remain.getDamageValue() == remain.getMaxDamage() ? ItemStack.EMPTY : remain;
    }
}

