/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.item.storage;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.common.container.storage.StorageRemoteContainer;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.util.BlockEntityUtil;
import com.klikli_dev.occultism.util.CuriosUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class StorageRemoteItem
extends Item
implements MenuProvider {
    public StorageRemoteItem(Item.Properties properties) {
        super(properties);
    }

    public static IStorageController getStorageController(ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return null;
        }
        if (!stack.has(OccultismDataComponents.LINKED_STORAGE_CONTROLLER)) {
            return null;
        }
        GlobalBlockPos globalPos = (GlobalBlockPos)stack.get(OccultismDataComponents.LINKED_STORAGE_CONTROLLER);
        BlockEntity blockEntity = BlockEntityUtil.get(level, globalPos);
        return blockEntity instanceof IStorageController ? (IStorageController)blockEntity : null;
    }

    public void verifyComponentsAfterLoad(ItemStack pStack) {
        super.verifyComponentsAfterLoad(pStack);
        if (pStack.has(OccultismDataComponents.LINKED_STORAGE_CONTROLLER)) {
            pStack.set(DataComponents.RARITY, (Object)Rarity.RARE);
        } else {
            pStack.set(DataComponents.RARITY, (Object)Rarity.COMMON);
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId());
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide) {
            ItemStack stack = context.getItemInHand();
            BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
            if (blockEntity instanceof IStorageController) {
                stack.set(OccultismDataComponents.LINKED_STORAGE_CONTROLLER, (Object)GlobalBlockPos.from(blockEntity));
                stack.set(DataComponents.RARITY, (Object)Rarity.RARE);
                context.getPlayer().sendSystemMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.linked")));
            }
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide || !stack.has(OccultismDataComponents.LINKED_STORAGE_CONTROLLER)) {
            return super.use(level, player, hand);
        }
        GlobalBlockPos storageControllerPos = (GlobalBlockPos)stack.get(OccultismDataComponents.LINKED_STORAGE_CONTROLLER);
        ServerLevel storageControllerWorld = level.getServer().getLevel(storageControllerPos.getDimensionKey());
        if (!storageControllerWorld.hasChunkAt(storageControllerPos.getPos())) {
            player.sendSystemMessage((Component)Component.translatable((String)(this.getDescriptionId() + ".message.not_loaded")));
            return super.use(level, player, hand);
        }
        if (storageControllerWorld.getBlockEntity(storageControllerPos.getPos()) instanceof IStorageController && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)this, buffer -> buffer.writeVarInt(player.getInventory().selected));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (pStack.has(OccultismDataComponents.LINKED_STORAGE_CONTROLLER)) {
            GlobalBlockPos globalPos = (GlobalBlockPos)pStack.get(OccultismDataComponents.LINKED_STORAGE_CONTROLLER);
            String formattedPosition = ChatFormatting.GOLD.toString() + String.valueOf(ChatFormatting.BOLD) + globalPos.toString() + String.valueOf(ChatFormatting.RESET);
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.linked"), (Object[])new Object[]{formattedPosition}));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)(this.getDescriptionId() + ".tooltip.unlinked")));
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        CuriosUtil.SelectedCurio selectedCurio = CuriosUtil.getStorageRemote(player);
        if (selectedCurio != null) {
            return new StorageRemoteContainer(id, playerInventory, selectedCurio.selectedSlot);
        }
        return null;
    }
}

