/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.job;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.entity.ai.behaviour.DepositItemsBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.HandleUnreachableCropBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.HarvestCropBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.PickupItemBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToCropBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToDepositBehaviour;
import com.klikli_dev.occultism.common.entity.ai.behaviour.SetWalkTargetToItemBehaviour;
import com.klikli_dev.occultism.common.entity.ai.sensor.NearestCropSensor;
import com.klikli_dev.occultism.common.entity.ai.sensor.NearestJobItemSensor;
import com.klikli_dev.occultism.common.entity.ai.sensor.UnreachableCropWalkTargetSensor;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.Tags;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;

public class FarmerJob
extends SpiritJob {
    protected List<Ingredient> itemsToPickUp = new ArrayList<Ingredient>();

    public FarmerJob(SpiritEntity entity) {
        super(entity);
    }

    @Override
    public List<ExtendedSensor<SpiritEntity>> getSensors() {
        return ImmutableList.of(new NearestCropSensor(), new NearestJobItemSensor(), new UnreachableCropWalkTargetSensor());
    }

    @Override
    public BrainActivityGroup<SpiritEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTargetSink(8, 8), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new MoveToWalkTarget(), new HarvestCropBehaviour(), new PickupItemBehaviour(), new DepositItemsBehaviour()})});
    }

    @Override
    public BrainActivityGroup<SpiritEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SetWalkTargetToCropBehaviour(), new SetWalkTargetToDepositBehaviour(), new SetWalkTargetToItemBehaviour()}), new HandleUnreachableCropBehaviour()});
    }

    @Override
    public void handleAdditionalBrainSetup(Brain<? extends SpiritEntity> brain) {
    }

    @Override
    public void onInit() {
        this.itemsToPickUp.add(Ingredient.of((TagKey)Tags.Items.SEEDS));
        this.itemsToPickUp.add(Ingredient.of((TagKey)Tags.Items.CROPS));
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean canPickupItem(ItemEntity entity) {
        ItemStack stack = entity.getItem();
        return !stack.isEmpty() && this.itemsToPickUp.stream().anyMatch(i -> i.test(stack));
    }

    @Override
    public List<Ingredient> getItemsToPickUp() {
        return this.itemsToPickUp;
    }

    @Override
    public void onChangeWorkArea() {
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.NO_CROP_IN_WORK_AREA.get());
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.UNREACHABLE_WALK_TARGETS.get());
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.UNREACHABLE_CROPS.get());
        BrainUtils.clearMemory((LivingEntity)this.entity, OccultismMemoryTypes.NON_CROP.get());
    }
}

