/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.goal;

import com.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class ReplantSaplingGoal
extends Goal {
    protected final SpiritEntity entity;
    protected final BlockSorter targetSorter;
    protected BlockPos moveTarget = null;

    public ReplantSaplingGoal(SpiritEntity entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    private BlockPos getMoveTarget() {
        double angle = Math3DUtil.yaw(this.entity.position(), Math3DUtil.center(this.moveTarget));
        return this.moveTarget.relative(Direction.fromYRot((double)angle).getOpposite());
    }

    public boolean canUse() {
        if (!this.entity.getItemInHand(InteractionHand.MAIN_HAND).is(ItemTags.SAPLINGS)) {
            return false;
        }
        this.resetTarget();
        return this.moveTarget != null;
    }

    public boolean canContinueToUse() {
        return true;
    }

    public void stop() {
        this.entity.getNavigation().stop();
        this.resetTarget();
    }

    public void tick() {
        if (this.moveTarget != null) {
            float accessDistance = 4.5f;
            double distance = this.entity.position().distanceTo(Math3DUtil.center(this.moveTarget));
            if (distance < (double)accessDistance) {
                this.entity.getNavigation().stop();
            } else {
                BlockPos moveTarget = this.getMoveTarget();
                this.entity.getNavigation().moveTo(this.entity.getNavigation().createPath(moveTarget, 0), 1.0);
            }
        } else {
            this.resetTarget();
        }
    }

    private void resetTarget() {
        this.moveTarget = null;
    }
}

