/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.familiar.BatFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BatFamiliarModel
extends EntityModel<BatFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body1;
    public ModelPart head;
    public ModelPart body2;
    public ModelPart leftEye;
    public ModelPart leftEar1;
    public ModelPart mouth;
    public ModelPart hair;
    public ModelPart ribbon;
    public ModelPart rightEye;
    public ModelPart rightEar1;
    public ModelPart leftEar2;
    public ModelPart leftEarBack1;
    public ModelPart leftEarBack2;
    public ModelPart nose;
    public ModelPart tooth;
    public ModelPart rightEar2;
    public ModelPart rightEarBack1;
    public ModelPart rightEarBack2;
    public ModelPart leftLeg;
    public ModelPart leftWing1;
    public ModelPart rightLeg;
    public ModelPart tail;
    public ModelPart rightWing1;
    public ModelPart stick;
    public ModelPart goblet1;
    public ModelPart goblet2;
    public ModelPart goblet3;
    public ModelPart goblet4;
    public ModelPart goblet5;
    public ModelPart goblet6;
    public ModelPart goblet7;
    public ModelPart leftWing2;
    public ModelPart leftWingBack1;
    public ModelPart leftWingBack2;
    public ModelPart rightWing2;
    public ModelPart rightWingBack1;
    public ModelPart rightWingBack2;
    public ModelPart leftChain1;
    public ModelPart rightChain1;
    public ModelPart leftChain2;
    public ModelPart leftChain3;
    public ModelPart rightChain2;
    public ModelPart rightChain3;

    public BatFamiliarModel(ModelPart part) {
        this.body1 = part.getChild("body1");
        this.head = this.body1.getChild("head");
        this.body2 = this.body1.getChild("body2");
        this.leftEye = this.head.getChild("leftEye");
        this.leftEar1 = this.head.getChild("leftEar1");
        this.mouth = this.head.getChild("mouth");
        this.hair = this.head.getChild("hair");
        this.ribbon = this.head.getChild("ribbon");
        this.rightEye = this.head.getChild("rightEye");
        this.rightEar1 = this.head.getChild("rightEar1");
        this.leftEar2 = this.leftEar1.getChild("leftEar2");
        this.leftEarBack1 = this.leftEar1.getChild("leftEarBack1");
        this.leftEarBack2 = this.leftEar2.getChild("leftEarBack2");
        this.nose = this.mouth.getChild("nose");
        this.tooth = this.mouth.getChild("tooth");
        this.rightEar2 = this.rightEar1.getChild("rightEar2");
        this.rightEarBack1 = this.rightEar1.getChild("rightEarBack1");
        this.rightEarBack2 = this.rightEar2.getChild("rightEarBack2");
        this.leftLeg = this.body2.getChild("leftLeg");
        this.leftWing1 = this.body2.getChild("leftWing1");
        this.rightLeg = this.body2.getChild("rightLeg");
        this.tail = this.body2.getChild("tail");
        this.rightWing1 = this.body2.getChild("rightWing1");
        this.stick = this.body2.getChild("stick");
        this.goblet1 = this.leftLeg.getChild("goblet1");
        this.goblet2 = this.goblet1.getChild("goblet2");
        this.goblet3 = this.goblet1.getChild("goblet3");
        this.goblet4 = this.goblet3.getChild("goblet4");
        this.goblet5 = this.goblet3.getChild("goblet5");
        this.goblet6 = this.goblet3.getChild("goblet6");
        this.goblet7 = this.goblet3.getChild("goblet7");
        this.leftWing2 = this.leftWing1.getChild("leftWing2");
        this.leftWingBack1 = this.leftWing1.getChild("leftWingBack1");
        this.leftWingBack2 = this.leftWing2.getChild("leftWingBack2");
        this.rightWing2 = this.rightWing1.getChild("rightWing2");
        this.rightWingBack1 = this.rightWing1.getChild("rightWingBack1");
        this.rightWingBack2 = this.rightWing2.getChild("rightWingBack2");
        this.leftChain1 = this.stick.getChild("leftChain1");
        this.rightChain1 = this.stick.getChild("rightChain1");
        this.leftChain2 = this.leftChain1.getChild("leftChain2");
        this.leftChain3 = this.leftChain2.getChild("leftChain3");
        this.rightChain2 = this.rightChain1.getChild("rightChain2");
        this.rightChain3 = this.rightChain2.getChild("rightChain3");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body1 = parts.addOrReplaceChild("body1", CubeListBuilder.create().texOffs(8, 10).addBox(-2.0f, 0.0f, -1.5f, 4.0f, 1.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)14.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(1, 0).addBox(-3.0f, -5.0f, -2.5f, 6.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body2 = body1.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(23, 0).addBox(-2.5f, 0.0f, -2.0f, 5.0f, 7.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.4f, (float)-3.2f, (float)-3.1f, (float)0.0f, (float)0.0f, (float)0.1972222f));
        PartDefinition leftEar1 = head.addOrReplaceChild("leftEar1", CubeListBuilder.create().texOffs(0, 27).addBox(-2.5f, -5.0f, 0.0f, 5.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)-4.5f, (float)0.5f, (float)0.0f, (float)-0.23649211f, (float)0.35499996f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 12).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-0.3f, (float)-3.0f, (float)0.17453292f, (float)0.0f, (float)0.0f));
        PartDefinition hair = head.addOrReplaceChild("hair", CubeListBuilder.create().texOffs(0, 18).addBox(-1.5f, -2.0f, 0.0f, 3.0f, 2.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.5f, (float)-4.8f, (float)-1.5f, (float)-0.039095376f, (float)0.0f, (float)-0.23457225f));
        PartDefinition ribbon = head.addOrReplaceChild("ribbon", CubeListBuilder.create().texOffs(0, 20).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 4.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)-2.51f, (float)-0.17453292f, (float)0.17453292f, (float)0.7853982f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)-1.4f, (float)-3.2f, (float)-3.1f, (float)0.0f, (float)0.0f, (float)-0.1972222f));
        PartDefinition rightEar1 = head.addOrReplaceChild("rightEar1", CubeListBuilder.create().texOffs(0, 27).addBox(-2.5f, -5.0f, 0.0f, 5.0f, 5.0f, 0.0f, true), PartPose.offsetAndRotation((float)-2.0f, (float)-4.5f, (float)0.5f, (float)0.0f, (float)0.23649211f, (float)-0.35499996f));
        PartDefinition leftEar2 = leftEar1.addOrReplaceChild("leftEar2", CubeListBuilder.create().texOffs(0, 25).addBox(-2.5f, -2.0f, 0.0f, 5.0f, 2.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.43633232f, (float)0.0f, (float)0.0f));
        PartDefinition leftEarBack1 = leftEar1.addOrReplaceChild("leftEarBack1", CubeListBuilder.create().texOffs(8, 20).addBox(-2.5f, -5.0f, 0.0f, 5.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.03f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEarBack2 = leftEar2.addOrReplaceChild("leftEarBack2", CubeListBuilder.create().texOffs(8, 18).addBox(-2.5f, -2.0f, 0.0f, 5.0f, 2.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.03f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = mouth.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-0.4f, (float)-0.4f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tooth = mouth.addOrReplaceChild("tooth", CubeListBuilder.create().texOffs(0, 4).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.5f, (float)0.9f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar2 = rightEar1.addOrReplaceChild("rightEar2", CubeListBuilder.create().texOffs(0, 25).addBox(-2.5f, -2.0f, 0.0f, 5.0f, 2.0f, 0.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.43633232f, (float)0.0f, (float)0.0f));
        PartDefinition rightEarBack1 = rightEar1.addOrReplaceChild("rightEarBack1", CubeListBuilder.create().texOffs(8, 20).addBox(-2.5f, -5.0f, 0.0f, 5.0f, 5.0f, 0.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.03f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEarBack2 = rightEar2.addOrReplaceChild("rightEarBack2", CubeListBuilder.create().texOffs(8, 18).addBox(-2.5f, -2.0f, 0.0f, 5.0f, 2.0f, 0.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.03f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body2.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(24, 20).addBox(-1.0f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.1f, (float)6.3f, (float)0.0f, (float)0.23666665f, (float)0.0f, (float)((float)Math.PI / 180)));
        PartDefinition leftWing1 = body2.addOrReplaceChild("leftWing1", CubeListBuilder.create().texOffs(44, 26).addBox(0.0f, -6.0f, 0.0f, 10.0f, 6.0f, 0.0f, false), PartPose.offsetAndRotation((float)1.8f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.17453292f));
        PartDefinition rightLeg = body2.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(24, 20).addBox(-1.0f, 0.0f, -0.5f, 2.0f, 3.0f, 1.0f, true), PartPose.offsetAndRotation((float)-1.1f, (float)6.3f, (float)0.0f, (float)0.23666665f, (float)0.0f, (float)((float)(-Math.PI) / 180)));
        PartDefinition tail = body2.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(34, 11).addBox(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)4.8f, (float)1.5f, (float)0.23666665f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing1 = body2.addOrReplaceChild("rightWing1", CubeListBuilder.create().texOffs(44, 26).addBox(-10.0f, -6.0f, 0.0f, 10.0f, 6.0f, 0.0f, true), PartPose.offsetAndRotation((float)-1.8f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.17453292f));
        PartDefinition stick = body2.addOrReplaceChild("stick", CubeListBuilder.create().texOffs(10, 14).addBox(-7.0f, 0.0f, 0.0f, 14.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition goblet1 = leftLeg.addOrReplaceChild("goblet1", CubeListBuilder.create().texOffs(10, 30).addBox(0.0f, -0.5f, -0.5f, 5.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-3.5f, (float)3.0f, (float)0.0f, (float)0.7853982f, (float)0.0f, (float)0.0f));
        PartDefinition goblet2 = goblet1.addOrReplaceChild("goblet2", CubeListBuilder.create().texOffs(10, 26).addBox(0.0f, -1.0f, -1.0f, 0.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition goblet3 = goblet1.addOrReplaceChild("goblet3", CubeListBuilder.create().texOffs(22, 26).addBox(0.0f, -1.5f, -1.5f, 3.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)5.01f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition goblet4 = goblet3.addOrReplaceChild("goblet4", CubeListBuilder.create().texOffs(31, 27).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition goblet5 = goblet3.addOrReplaceChild("goblet5", CubeListBuilder.create().texOffs(35, 27).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition goblet6 = goblet3.addOrReplaceChild("goblet6", CubeListBuilder.create().texOffs(34, 29).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)0.0f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition goblet7 = goblet3.addOrReplaceChild("goblet7", CubeListBuilder.create().texOffs(38, 29).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)0.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        PartDefinition leftWing2 = leftWing1.addOrReplaceChild("leftWing2", CubeListBuilder.create().texOffs(44, 20).addBox(0.0f, -6.0f, 0.0f, 10.0f, 6.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWingBack1 = leftWing1.addOrReplaceChild("leftWingBack1", CubeListBuilder.create().texOffs(44, 14).addBox(0.0f, -6.0f, 0.0f, 10.0f, 6.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.03f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftWingBack2 = leftWing2.addOrReplaceChild("leftWingBack2", CubeListBuilder.create().texOffs(44, 8).addBox(0.0f, -6.0f, 0.0f, 10.0f, 6.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.03f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing2 = rightWing1.addOrReplaceChild("rightWing2", CubeListBuilder.create().texOffs(44, 20).addBox(-10.0f, -6.0f, 0.0f, 10.0f, 6.0f, 0.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightWingBack1 = rightWing1.addOrReplaceChild("rightWingBack1", CubeListBuilder.create().texOffs(44, 14).addBox(-10.0f, -6.0f, 0.0f, 10.0f, 6.0f, 0.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.03f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightWingBack2 = rightWing2.addOrReplaceChild("rightWingBack2", CubeListBuilder.create().texOffs(44, 8).addBox(-10.0f, -6.0f, 0.0f, 10.0f, 6.0f, 0.0f, true), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.03f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftChain1 = stick.addOrReplaceChild("leftChain1", CubeListBuilder.create().texOffs(41, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)7.0f, (float)1.0f, (float)0.5f, (float)0.0f, (float)-0.5235988f, (float)0.0f));
        PartDefinition rightChain1 = stick.addOrReplaceChild("rightChain1", CubeListBuilder.create().texOffs(41, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)-7.0f, (float)1.0f, (float)0.5f, (float)0.0f, (float)-0.5235988f, (float)0.0f));
        PartDefinition leftChain2 = leftChain1.addOrReplaceChild("leftChain2", CubeListBuilder.create().texOffs(47, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)1.0471976f, (float)0.0f));
        PartDefinition leftChain3 = leftChain2.addOrReplaceChild("leftChain3", CubeListBuilder.create().texOffs(53, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
        PartDefinition rightChain2 = rightChain1.addOrReplaceChild("rightChain2", CubeListBuilder.create().texOffs(47, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)1.0471976f, (float)0.0f));
        PartDefinition rightChain3 = rightChain2.addOrReplaceChild("rightChain3", CubeListBuilder.create().texOffs(53, 0).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body1.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    public void setupAnim(BatFamiliarEntity pEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.showModels(pEntity);
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        this.body1.yRot = 0.0f;
        this.body1.zRot = 0.0f;
        this.head.xRot = this.toRads(headPitch);
        this.head.yRot = this.toRads(netHeadYaw);
        this.head.zRot = 0.0f;
        this.leftEar1.xRot = 0.0f;
        this.rightEar1.xRot = 0.0f;
        float animationHeight = pEntity.getAnimationHeight(partialTicks);
        this.leftWing1.xRot = animationHeight * this.toRads(20.0f) - 0.15f;
        this.rightWing1.xRot = animationHeight * this.toRads(20.0f) - 0.15f;
        this.leftWing1.yRot = animationHeight * this.toRads(20.0f) - 0.15f;
        this.rightWing1.yRot = -animationHeight * this.toRads(20.0f) + 0.15f;
        this.leftWing2.xRot = animationHeight * this.toRads(20.0f) + this.toRads(15.0f);
        this.rightWing2.xRot = animationHeight * this.toRads(20.0f) + this.toRads(15.0f);
        this.body1.xRot = this.toRads(20.0f) + limbSwingAmount * this.toRads(30.0f);
        this.leftLeg.xRot = 0.24f + Mth.cos((float)(ageInTicks * 0.1f)) * this.toRads(20.0f);
        this.rightLeg.xRot = 0.24f + Mth.cos((float)(ageInTicks * 0.1f)) * this.toRads(20.0f);
        if (pEntity.isPartying()) {
            float headRot = Mth.sin((float)(ageInTicks / 3.0f)) * this.toRads(10.0f);
            float wingRot = Mth.sin((float)(ageInTicks / 3.0f)) * this.toRads(40.0f);
            this.head.xRot = headRot;
            this.head.yRot = headRot;
            this.head.zRot = headRot;
            this.leftWing1.xRot = wingRot;
            this.rightWing1.xRot = wingRot;
            this.leftWing1.yRot = wingRot;
            this.rightWing1.yRot = wingRot;
            this.leftWing2.xRot = wingRot;
            this.rightWing2.xRot = wingRot;
            this.body1.xRot = this.toRads(20.0f) + limbSwingAmount * this.toRads(70.0f);
            this.leftEar1.xRot = Mth.cos((float)(ageInTicks / 3.0f + (float)Math.PI)) * this.toRads(25.0f);
            this.rightEar1.xRot = Mth.cos((float)(ageInTicks / 3.0f)) * this.toRads(25.0f);
        } else if (pEntity.isSitting()) {
            this.leftWing1.xRot = this.toRads(0.0f);
            this.rightWing1.xRot = this.toRads(0.0f);
            this.leftWing1.yRot = this.toRads(80.0f);
            this.rightWing1.yRot = -this.toRads(80.0f);
            this.leftWing2.xRot = this.toRads(15.0f);
            this.rightWing2.xRot = this.toRads(15.0f);
            this.head.xRot = 0.2f;
            this.body1.xRot = this.toRads(180.0f);
            this.body1.yRot = this.toRads(180.0f);
            this.leftLeg.xRot = 0.24f;
            this.rightLeg.xRot = 0.24f;
        }
    }

    private float toRads(float deg) {
        return (float)Math.toRadians(deg);
    }

    private void showModels(BatFamiliarEntity entityIn) {
        boolean isSitting = entityIn.isSitting();
        boolean isPartying = entityIn.isPartying();
        this.stick.visible = isSitting && !isPartying;
        this.goblet1.visible = entityIn.hasBlacksmithUpgrade() && (!isSitting || isPartying);
        this.hair.visible = entityIn.hasHair();
        this.ribbon.visible = entityIn.hasRibbon();
        this.tail.visible = entityIn.hasTail();
    }

    public void setRotateAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

