/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SizedImageButton
extends Button {
    public final ResourceLocation resourceLocation;
    public final int xTexStart;
    public final int yTexStart;
    public final int xDiffOffset;
    public final int textureWidth;
    public final int textureHeight;
    public final int textureMapWidth;
    public final int textureMapHeight;

    public SizedImageButton(int xIn, int yIn, int widthIn, int heightIn, int textureOffsetX, int textureOffsetY, int hoverOffsetX, int textureWidth, int textureHeight, int textureMapWidth, int textureMapHeight, ResourceLocation resourceLocation, Button.OnPress handler) {
        super(xIn, yIn, widthIn, heightIn, (Component)Component.empty(), handler, DEFAULT_NARRATION);
        this.xTexStart = textureOffsetX;
        this.yTexStart = textureOffsetY;
        this.xDiffOffset = hoverOffsetX;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.textureMapWidth = textureMapWidth;
        this.textureMapHeight = textureMapHeight;
        this.resourceLocation = resourceLocation;
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            int i = this.xTexStart;
            int j = this.yTexStart;
            if (this.isHoveredOrFocused()) {
                i += this.xDiffOffset;
            }
            RenderSystem.enableDepthTest();
            guiGraphics.blit(this.resourceLocation, this.getX(), this.getY(), this.width, this.height, (float)i, (float)j, this.textureWidth, this.textureHeight, this.textureMapWidth, this.textureMapHeight);
        }
    }
}

