/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TooltipUtil {
    public static void renderItems(GuiGraphics guiGraphics, List<ItemStack> items, int x, int y) {
        for (int i = 0; i < items.size(); ++i) {
            TooltipUtil.renderItemIntoGUI(guiGraphics, items.get(i), x + 18 * i, y, 512);
        }
    }

    public static void renderItemIntoGUI(GuiGraphics guiGraphics, ItemStack stack, int x, int y, int z) {
        TooltipUtil.renderItemModelIntoGUI(guiGraphics, stack, x, y, z, Minecraft.getInstance().getItemRenderer().getModel(stack, (Level)null, (LivingEntity)null, 0));
    }

    public static void renderItemAdvanced(GuiGraphics guiGraphics, ItemStack stack, int x, int y, int z, String amount) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, (float)z);
        TooltipUtil.renderItemModelIntoGUI(guiGraphics, stack, x, y, z, Minecraft.getInstance().getItemRenderer().getModel(stack, (Level)null, (LivingEntity)null, 0));
        TooltipUtil.renderItemStackOverlay(guiGraphics, Minecraft.getInstance().font, stack, x, y, amount, amount.length() - 2);
        guiGraphics.pose().popPose();
    }

    public static void renderItemStackOverlay(GuiGraphics guiGraphics, Font fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int scaled) {
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 544.0f);
        if (!(stack.isEmpty() || stack.getCount() == 1 && text == null)) {
            Object s;
            Object object = s = text == null ? String.valueOf(stack.getCount()) : text;
            if (text == null && stack.getCount() < 1) {
                ChatFormatting var10000 = ChatFormatting.RED;
                s = String.valueOf(var10000) + String.valueOf(stack.getCount());
            }
            matrixStack.translate(0.0, 0.0, 200.0);
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
            if (scaled >= 2) {
                matrixStack.pushPose();
                matrixStack.scale(0.5f, 0.5f, 0.5f);
                guiGraphics.drawString(fr, (String)s, (xPosition + 19 - 2) * 2 - 1 - fr.width((String)s), yPosition * 2 + 24, 0xFFFFFF, true);
                matrixStack.popPose();
            } else if (scaled == 1) {
                matrixStack.pushPose();
                matrixStack.scale(0.75f, 0.75f, 0.75f);
                guiGraphics.drawString(fr, (String)s, (float)(xPosition - 2) * 1.34f + 24.0f - (float)fr.width((String)s), (float)yPosition * 1.34f + 14.0f, 0xFFFFFF, true);
                matrixStack.popPose();
            } else {
                guiGraphics.drawString(fr, (String)s, (float)(xPosition + 19 - 2 - fr.width((String)s)), (float)(yPosition + 6 + 3), 0xFFFFFF, true);
            }
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
        }
        matrixStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemModelIntoGUI(GuiGraphics guiGraphics, ItemStack stack, int x, int y, int z, BakedModel bakedmodel) {
        boolean flag;
        PoseStack posestack = guiGraphics.pose();
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        posestack.pushPose();
        posestack.translate((double)x, (double)y, (double)z);
        posestack.translate(8.0, 8.0, 0.0);
        posestack.scale(1.0f, -1.0f, 1.0f);
        posestack.scale(16.0f, 16.0f, 16.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = flag = !bakedmodel.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
        }
        Minecraft.getInstance().getItemRenderer().render(stack, ItemDisplayContext.GUI, false, posestack, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedmodel);
        multibuffersource$buffersource.endBatch();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        posestack.popPose();
        RenderSystem.applyModelViewMatrix();
    }
}

