/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.recipe;

import com.buuz135.functionalstorage.util.Utils;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;

public class TagWithoutComponentIngredient
implements ICustomIngredient {
    public static final MapCodec<TagWithoutComponentIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)TagKey.codec((ResourceKey)BuiltInRegistries.ITEM.key()).fieldOf("tag").forGetter(TagWithoutComponentIngredient::getTag)).apply((Applicative)builder, TagWithoutComponentIngredient::new));
    public static Holder<IngredientType<?>> TYPE;
    public static final ResourceLocation NAME;
    private final TagKey<Item> tag;

    public TagWithoutComponentIngredient(TagKey<Item> tag) {
        this.tag = tag;
    }

    public boolean test(ItemStack stack) {
        return stack.is(this.tag) && stack.getComponentsPatch().isEmpty();
    }

    public List<ItemStack> getListOfItems() {
        ArrayList list = Lists.newArrayList();
        for (Holder holder : BuiltInRegistries.ITEM.getTagOrEmpty(this.tag)) {
            list.add(new ItemStack(holder));
        }
        if (list.isEmpty()) {
            ItemStack itemStack = new ItemStack((ItemLike)Blocks.BARRIER);
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Empty Tag: " + String.valueOf(this.tag.location()))));
            list.add(itemStack);
        }
        return list;
    }

    public Stream<ItemStack> getItems() {
        return this.getListOfItems().stream();
    }

    public boolean isSimple() {
        return false;
    }

    public IngredientType<?> getType() {
        return (IngredientType)TYPE.value();
    }

    public TagKey<Item> getTag() {
        return this.tag;
    }

    static {
        NAME = Utils.resourceLocation("functionalstorage", "tag_without_component");
    }
}

