/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.inventory.item;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.buuz135.functionalstorage.item.component.SizeProvider;
import com.buuz135.functionalstorage.util.CompactingUtil;
import com.buuz135.functionalstorage.util.Utils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CompactingStackItemHandler
implements IItemHandler,
INBTSerializable<CompoundTag> {
    public static String PARENT = "Parent";
    public static String BIG_ITEMS = "BigItems";
    public static String STACK = "Stack";
    public static String AMOUNT = "Amount";
    private int amount;
    private ItemStack parent;
    private List<CompactingUtil.Result> resultList;
    private final int slots;
    private float size;
    private boolean isVoid;
    private boolean isCreative;
    private final ItemStack stack;

    public CompactingStackItemHandler(ItemStack stack, int slots) {
        this.stack = stack;
        this.resultList = new ArrayList<CompactingUtil.Result>();
        this.slots = slots;
        this.size = 512.0f;
        for (int i = 0; i < slots; ++i) {
            this.resultList.add(i, new CompactingUtil.Result(ItemStack.EMPTY, 1));
        }
        this.parent = ItemStack.EMPTY;
        this.isVoid = false;
        this.isCreative = false;
        if (stack.has(FSAttachments.TILE)) {
            ItemStack itemStack;
            CompoundTag tile = (CompoundTag)stack.get(FSAttachments.TILE);
            this.deserializeNBT((HolderLookup.Provider)Utils.registryAccess(), tile.getCompound("handler"));
            ItemStackHandler upgrades = new ItemStackHandler();
            upgrades.deserializeNBT((HolderLookup.Provider)Utils.registryAccess(), tile.getCompound("storageUpgrades"));
            this.size = SizeProvider.calculateAsFactor((IItemHandler)upgrades, FSAttachments.ITEM_STORAGE_MODIFIER, this.size);
            for (Tag tag : tile.getCompound("storageUpgrades").getList("Items", 10)) {
                itemStack = Utils.deserialize((HolderLookup.Provider)Utils.registryAccess(), (CompoundTag)tag);
                if (!itemStack.getItem().equals(FunctionalStorage.CREATIVE_UPGRADE.get())) continue;
                this.isCreative = true;
            }
            for (Tag tag : tile.getCompound("utilityUpgrades").getList("Items", 10)) {
                itemStack = Utils.deserialize((HolderLookup.Provider)Utils.registryAccess(), (CompoundTag)tag);
                if (!itemStack.getItem().equals(FunctionalStorage.VOID_UPGRADE.get())) continue;
                this.isVoid = true;
            }
        }
    }

    public int getSlots() {
        if (this.isVoid()) {
            return this.slots + 1;
        }
        return this.slots;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.slots) {
            return ItemStack.EMPTY;
        }
        CompactingUtil.Result bigStack = this.resultList.get(slot);
        ItemStack copied = bigStack.getResult().copy();
        copied.setCount(this.isCreative() ? Integer.MAX_VALUE : this.amount / bigStack.getNeeded());
        return copied;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isVoid() && slot == this.slots && this.isVoidValid(stack) || this.isVoidValid(stack) && this.isCreative()) {
            return ItemStack.EMPTY;
        }
        if (this.isValid(slot, stack)) {
            CompactingUtil.Result result = this.resultList.get(slot);
            int inserted = Math.min(this.getSlotLimit(slot) * result.getNeeded() - this.amount, stack.getCount() * result.getNeeded());
            inserted = (int)(Math.floor(inserted / result.getNeeded()) * (double)result.getNeeded());
            if (!simulate) {
                this.amount = Math.min(this.amount + inserted, (int)Math.floor(this.size * 64.0f * 9.0f * 9.0f));
                this.onChange();
            }
            if (inserted == stack.getCount() * result.getNeeded() || this.isVoid()) {
                return ItemStack.EMPTY;
            }
            return stack.copyWithCount(stack.getCount() - inserted / result.getNeeded());
        }
        return stack;
    }

    private boolean isVoidValid(ItemStack stack) {
        for (CompactingUtil.Result result : this.resultList) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)result.getResult(), (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public boolean isSetup() {
        return !this.resultList.get(this.resultList.size() - 1).getResult().isEmpty();
    }

    public void setup(CompactingUtil compactingUtil) {
        this.resultList = compactingUtil.getResults();
        this.parent = compactingUtil.getResults().get(0).getResult();
        if (this.parent.isEmpty()) {
            this.parent = compactingUtil.getResults().get(1).getResult();
        }
        if (this.parent.isEmpty() && compactingUtil.getResults().size() >= 3) {
            this.parent = compactingUtil.getResults().get(2).getResult();
        }
        this.onChange();
    }

    public void reset() {
    }

    public int getAmount() {
        return this.amount;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || slot == this.slots) {
            return ItemStack.EMPTY;
        }
        if (slot < this.slots) {
            CompactingUtil.Result bigStack = this.resultList.get(slot);
            if (bigStack.getResult().isEmpty()) {
                return ItemStack.EMPTY;
            }
            int stackAmount = bigStack.getNeeded() * amount;
            if (stackAmount >= this.amount) {
                ItemStack out = bigStack.getResult().copy();
                int newAmount = (int)Math.floor(this.amount / bigStack.getNeeded());
                if (!simulate && !this.isCreative()) {
                    this.amount -= newAmount * bigStack.getNeeded();
                    if (this.amount == 0) {
                        this.reset();
                    }
                    this.onChange();
                }
                out.setCount(newAmount);
                return out;
            }
            if (!simulate && !this.isCreative()) {
                this.amount -= stackAmount;
                this.onChange();
            }
            return bigStack.getResult().copyWithCount(amount);
        }
        return ItemStack.EMPTY;
    }

    public int getSlotLimit(int slot) {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        if (slot == this.slots) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.min(2.147483647E9, Math.floor(this.size * 64.0f * 9.0f * 9.0f / (float)this.resultList.get(slot).getNeeded()));
    }

    public int getSlotLimitBase(int slot) {
        if (slot == this.slots) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.min(2.147483647E9, Math.floor(this.size * 64.0f * 9.0f * 9.0f / (float)this.resultList.get(slot).getNeeded()));
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.isSetup() && !stack.isEmpty();
    }

    private boolean isValid(int slot, @Nonnull ItemStack stack) {
        if (slot < this.slots) {
            CompactingUtil.Result bigStack = this.resultList.get(slot);
            ItemStack fl = bigStack.getResult();
            return !fl.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)fl, (ItemStack)stack);
        }
        return false;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.put(PARENT, this.getParent().saveOptional(provider));
        compoundTag.putInt(AMOUNT, this.amount);
        CompoundTag items = new CompoundTag();
        for (int i = 0; i < this.resultList.size(); ++i) {
            CompoundTag bigStack = new CompoundTag();
            bigStack.put(STACK, this.resultList.get(i).getResult().saveOptional(provider));
            bigStack.putInt(AMOUNT, this.resultList.get(i).getNeeded());
            items.put("" + i, (Tag)bigStack);
        }
        compoundTag.put(BIG_ITEMS, (Tag)items);
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.parent = Utils.deserialize(provider, nbt.getCompound(PARENT));
        this.amount = nbt.getInt(AMOUNT);
        for (String allKey : nbt.getCompound(BIG_ITEMS).getAllKeys()) {
            this.resultList.get(Integer.parseInt(allKey)).setResult(Utils.deserialize(provider, nbt.getCompound(BIG_ITEMS).getCompound(allKey).getCompound(STACK)));
            this.resultList.get(Integer.parseInt(allKey)).setNeeded(Math.max(1, nbt.getCompound(BIG_ITEMS).getCompound(allKey).getInt(AMOUNT)));
        }
    }

    public void onChange() {
        this.stack.set(FSAttachments.TILE, (Object)new CompoundTag());
        ((CompoundTag)this.stack.get(FSAttachments.TILE)).put("handler", (Tag)this.serializeNBT((HolderLookup.Provider)Utils.registryAccess()));
    }

    public boolean isVoid() {
        return this.isVoid;
    }

    public List<CompactingUtil.Result> getResultList() {
        return this.resultList;
    }

    public ItemStack getParent() {
        return this.parent;
    }

    public boolean isCreative() {
        return this.isCreative;
    }
}

