/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.compat.jade;

import com.buuz135.functionalstorage.block.config.FunctionalStorageConfig;
import com.buuz135.functionalstorage.block.tile.ArmoryCabinetTile;
import com.buuz135.functionalstorage.util.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public enum ArmoryComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;

    public static final ResourceLocation ID;

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        IElementHelper helper = IElementHelper.get();
        if (blockAccessor.getBlockEntity() instanceof ArmoryCabinetTile && blockAccessor.getServerData().contains(this.getUid().toLanguageKey())) {
            int count = blockAccessor.getServerData().getInt(this.getUid().toLanguageKey());
            iTooltip.add(helper.text((Component)Component.literal((String)(count + " / " + FunctionalStorageConfig.ARMORY_CABINET_SIZE))).translate(new Vec2(4.0f, 2.7400002f)));
        }
    }

    public void appendServerData(CompoundTag data, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof ArmoryCabinetTile) {
            ArmoryCabinetTile armory = (ArmoryCabinetTile)blockEntity;
            long count = armory.handler.stackList.stream().filter(stack -> !stack.isEmpty()).count();
            data.putLong(this.getUid().toLanguageKey(), count);
        }
    }

    public int getDefaultPriority() {
        return 999;
    }

    public ResourceLocation getUid() {
        return ID;
    }

    static {
        ID = Utils.resourceLocation("functionalstorage", "armory");
    }
}

