/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.Drawer;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.SimpleCompactingDrawerBlock;
import com.buuz135.functionalstorage.block.tile.CompactingDrawerTile;
import com.buuz135.functionalstorage.client.item.CompactingDrawerISTER;
import com.buuz135.functionalstorage.inventory.item.CompactingStackItemHandler;
import com.buuz135.functionalstorage.recipe.TagWithoutComponentIngredient;
import com.buuz135.functionalstorage.util.StorageTags;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.RotatableBlock;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;

public class CompactingDrawerBlock
extends Drawer<CompactingDrawerTile> {
    public static Multimap<Direction, VoxelShape> CACHED_SHAPES = MultimapBuilder.hashKeys().arrayListValues().build();
    public static final HashMap<Direction, HashMap<Direction, List<VoxelShape>>> CACHED_ROTATED_SHAPES = new HashMap();

    public CompactingDrawerBlock(String name, BlockBehaviour.Properties properties) {
        super(name, properties, CompactingDrawerTile.class);
        this.setItemGroup(FunctionalStorage.TAB);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)Drawer.FACING_HORIZONTAL_CUSTOM, (Comparable)Direction.NORTH)).setValue((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntityType.BlockEntitySupplier<CompactingDrawerTile> getTileEntityFactory() {
        return (blockPos, state) -> new CompactingDrawerTile((BasicTileBlock<CompactingDrawerTile>)this, (BlockEntityType<CompactingDrawerTile>)((BlockEntityType)FunctionalStorage.COMPACTING_DRAWER.type().get()), blockPos, state);
    }

    public List<VoxelShape> getBoundingBoxes(BlockState state, BlockGetter source, BlockPos pos) {
        return CompactingDrawerBlock.getShapes(state, source, pos);
    }

    private static List<VoxelShape> getShapes(BlockState state, BlockGetter source, BlockPos pos) {
        ArrayList<VoxelShape> boxes = new ArrayList<VoxelShape>();
        Direction facing = (Direction)state.getValue((Property)Drawer.FACING_HORIZONTAL_CUSTOM);
        if (facing == Direction.UP || facing == Direction.DOWN) {
            Direction subfacing = (Direction)state.getValue((Property)RotatableBlock.FACING_ALL);
            boxes.addAll((Collection)CACHED_ROTATED_SHAPES.get(facing).get(subfacing));
        } else {
            CACHED_SHAPES.get((Object)facing).forEach(boxes::add);
        }
        VoxelShape total = Shapes.block();
        boxes.add(total);
        return boxes;
    }

    @Override
    public Collection<VoxelShape> getHitShapes(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)Drawer.FACING_HORIZONTAL_CUSTOM);
        if (facing == Direction.UP || facing == Direction.DOWN) {
            List shapes;
            Direction subfacing = (Direction)state.getValue((Property)RotatableBlock.FACING_ALL);
            if (facing == Direction.UP) {
                shapes = CACHED_ROTATED_SHAPES.get(facing).get(subfacing).stream().toList();
                if (subfacing == Direction.EAST || subfacing == Direction.NORTH) {
                    return Arrays.asList((VoxelShape)shapes.get(1), (VoxelShape)shapes.get(0), (VoxelShape)shapes.get(2));
                }
            }
            if (facing == Direction.DOWN) {
                shapes = CACHED_ROTATED_SHAPES.get(facing).get(subfacing).stream().toList();
                if (subfacing == Direction.WEST || subfacing == Direction.SOUTH) {
                    return Arrays.asList((VoxelShape)shapes.get(1), (VoxelShape)shapes.get(0), (VoxelShape)shapes.get(2));
                }
            }
            return CACHED_ROTATED_SHAPES.get(facing).get(subfacing);
        }
        return CACHED_SHAPES.get((Object)facing);
    }

    public void registerRecipe(RecipeOutput consumer) {
        TitaniumShapedRecipeBuilder.shapedRecipe((ItemLike)this).pattern("SSS").pattern("PDP").pattern("SIS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('P'), (ItemLike)Blocks.PISTON).define(Character.valueOf('D'), new TagWithoutComponentIngredient(StorageTags.DRAWER).toVanilla()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).save(consumer);
    }

    static {
        CACHED_SHAPES.put((Object)Direction.NORTH, (Object)Shapes.box((double)0.0625, (double)0.0625, (double)0.0, (double)0.4375, (double)0.4375, (double)0.0625));
        CACHED_SHAPES.put((Object)Direction.NORTH, (Object)Shapes.box((double)0.5625, (double)0.0625, (double)0.0, (double)0.9375, (double)0.4375, (double)0.0625));
        CACHED_SHAPES.put((Object)Direction.NORTH, (Object)Shapes.box((double)0.0625, (double)0.5625, (double)0.0, (double)0.9375, (double)0.9375, (double)0.0625));
        CACHED_SHAPES.put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.5625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.4375, (double)1.0));
        CACHED_SHAPES.put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.0625, (double)0.0625, (double)0.9375, (double)0.4375, (double)0.4375, (double)1.0));
        CACHED_SHAPES.put((Object)Direction.SOUTH, (Object)Shapes.box((double)0.0625, (double)0.5625, (double)0.9375, (double)0.9375, (double)0.9375, (double)1.0));
        CACHED_SHAPES.put((Object)Direction.EAST, (Object)Shapes.box((double)0.9375, (double)0.0625, (double)0.0625, (double)1.0, (double)0.4375, (double)0.4375));
        CACHED_SHAPES.put((Object)Direction.EAST, (Object)Shapes.box((double)0.9375, (double)0.0625, (double)0.5625, (double)1.0, (double)0.4375, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.EAST, (Object)Shapes.box((double)0.9375, (double)0.5625, (double)0.0625, (double)1.0, (double)0.9375, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.WEST, (Object)Shapes.box((double)0.0, (double)0.0625, (double)0.5625, (double)0.0625, (double)0.4375, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.WEST, (Object)Shapes.box((double)0.0, (double)0.0625, (double)0.0625, (double)0.0625, (double)0.4375, (double)0.4375));
        CACHED_SHAPES.put((Object)Direction.WEST, (Object)Shapes.box((double)0.0, (double)0.5625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.UP, (Object)Shapes.box((double)0.0625, (double)0.9375, (double)0.0625, (double)0.4375, (double)1.0, (double)0.4375));
        CACHED_SHAPES.put((Object)Direction.UP, (Object)Shapes.box((double)0.5625, (double)0.9375, (double)0.0625, (double)0.9375, (double)1.0, (double)0.4375));
        CACHED_SHAPES.put((Object)Direction.UP, (Object)Shapes.box((double)0.0625, (double)0.9375, (double)0.5625, (double)0.9375, (double)1.0, (double)0.9375));
        CACHED_SHAPES.put((Object)Direction.DOWN, (Object)Shapes.box((double)0.0625, (double)0.0, (double)0.0625, (double)0.4375, (double)0.0625, (double)0.4375));
        CACHED_SHAPES.put((Object)Direction.DOWN, (Object)Shapes.box((double)0.5625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.0625, (double)0.4375));
        CACHED_SHAPES.put((Object)Direction.DOWN, (Object)Shapes.box((double)0.0625, (double)0.0, (double)0.5625, (double)0.9375, (double)0.0625, (double)0.9375));
        CACHED_ROTATED_SHAPES.put(Direction.UP, new HashMap());
        CACHED_ROTATED_SHAPES.put(Direction.DOWN, new HashMap());
        for (Direction facing : new Direction[]{Direction.UP, Direction.DOWN}) {
            for (Direction subfacing : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
                CACHED_ROTATED_SHAPES.get(facing).put(subfacing, new ArrayList());
            }
            Collection originalShapes = CACHED_SHAPES.get((Object)facing);
            for (VoxelShape shape : originalShapes) {
                AABB bounds = (AABB)shape.toAabbs().get(0);
                CACHED_ROTATED_SHAPES.get(facing).get(Direction.SOUTH).add(shape);
                VoxelShape eastShape = Shapes.box((double)bounds.minZ, (double)bounds.minY, (double)bounds.minX, (double)bounds.maxZ, (double)bounds.maxY, (double)bounds.maxX);
                CACHED_ROTATED_SHAPES.get(facing).get(Direction.EAST).add(eastShape);
                AABB southBounds = (AABB)shape.toAabbs().get(0);
                VoxelShape northShape = Shapes.box((double)southBounds.minX, (double)southBounds.minY, (double)(1.0 - southBounds.maxZ), (double)southBounds.maxX, (double)southBounds.maxY, (double)(1.0 - southBounds.minZ));
                CACHED_ROTATED_SHAPES.get(facing).get(Direction.NORTH).add(northShape);
                AABB eastBounds = (AABB)eastShape.toAabbs().get(0);
                VoxelShape westShape = Shapes.box((double)(1.0 - eastBounds.maxX), (double)eastBounds.minY, (double)eastBounds.minZ, (double)(1.0 - eastBounds.minX), (double)eastBounds.maxY, (double)eastBounds.maxZ);
                CACHED_ROTATED_SHAPES.get(facing).get(Direction.WEST).add(westShape);
            }
        }
    }

    public static class CompactingDrawerItem
    extends BlockItem {
        private final int slots;

        public CompactingDrawerItem(Block block, Item.Properties properties, int slots) {
            super(block, properties);
            this.slots = slots;
        }

        public IItemHandler initCapabilities(ItemStack stack) {
            return new CompactingStackItemHandler(stack, this.slots);
        }

        public void initializeClient(Consumer<IClientItemExtensions> consumer) {
            consumer.accept(new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return this.getBlock() instanceof SimpleCompactingDrawerBlock ? CompactingDrawerISTER.SIMPLE : CompactingDrawerISTER.NORMAL;
                }
            });
        }
    }
}

