/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.server.storage;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class ChunkLoadingData
extends SavedData {
    public Map<UUID, Set<ChunkPos>> chunks = new ConcurrentHashMap<UUID, Set<ChunkPos>>();

    public Set<ChunkPos> get(UUID uuid) {
        return this.chunks.getOrDefault(uuid, new HashSet());
    }

    public boolean updateChunk(UUID uuid, ChunkPos pos, boolean status) {
        boolean updated;
        Set chunkSet = this.chunks.getOrDefault(uuid, new HashSet());
        boolean bl = updated = status ? chunkSet.add(pos) : chunkSet.remove(pos);
        if (updated) {
            this.setDirty();
        }
        return updated;
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        for (Map.Entry<UUID, Set<ChunkPos>> entry : this.chunks.entrySet()) {
            ListTag chunkList = new ListTag();
            List<LongTag> tags = entry.getValue().stream().map(ChunkPos::toLong).map(LongTag::valueOf).toList();
            chunkList.addAll(tags);
            tag.put(entry.getKey().toString(), (Tag)chunkList);
        }
        return tag;
    }

    public static ChunkLoadingData create() {
        return new ChunkLoadingData();
    }

    public static ChunkLoadingData load(CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ChunkLoadingData data = ChunkLoadingData.create();
        List<UUID> uuids = tag.getAllKeys().stream().map(UUID::fromString).toList();
        for (UUID uuid : uuids) {
            HashSet<ChunkPos> chunks = new HashSet<ChunkPos>();
            ListTag longs = tag.getList(uuid.toString(), 4);
            for (Tag longChunk : longs) {
                if (!(longChunk instanceof LongTag)) continue;
                LongTag longTag = (LongTag)longChunk;
                chunks.add(new ChunkPos(longTag.getAsLong()));
            }
            data.chunks.put(uuid, chunks);
        }
        return data;
    }

    public static ChunkLoadingData getData(ServerLevel level) {
        return (ChunkLoadingData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(ChunkLoadingData::create, ChunkLoadingData::load), "chunkloading_data");
    }

    public static Map<ResourceKey<Level>, Set<ChunkPos>> getChunks(MinecraftServer server, UUID uuid) {
        HashMap<ResourceKey<Level>, Set<ChunkPos>> chunkMap = new HashMap<ResourceKey<Level>, Set<ChunkPos>>();
        for (ServerLevel level : server.getAllLevels()) {
            Set<ChunkPos> chunks = ChunkLoadingData.getData(level).get(uuid);
            chunkMap.put((ResourceKey<Level>)level.dimension(), chunks);
        }
        return chunkMap;
    }

    public static int countChunks(MinecraftServer server, UUID uuid) {
        return ChunkLoadingData.getChunks(server, uuid).values().stream().map(Set::size).reduce(0, Integer::sum);
    }

    private static void logInfo(boolean shouldLoad, ChunkPos pos, UUID uuid) {
        if (!((Boolean)ServerConfig.SERVER.chunkloading_log_loading.get()).booleanValue()) {
            return;
        }
        if (shouldLoad) {
            ArsAdditions.LOGGER.info("[Chunk Loader] Forceloading {} for {}", (Object)pos, (Object)uuid);
        } else {
            ArsAdditions.LOGGER.info("[Chunk Loader] Unloading {} for {}", (Object)pos, (Object)uuid);
        }
    }

    public static boolean updateChunk(ServerLevel level, UUID uuid, ChunkPos pos, boolean shouldLoad) {
        boolean updated = ChunkLoadingData.getData(level).updateChunk(uuid, pos, shouldLoad);
        boolean isLoaded = level.getForcedChunks().contains(pos.toLong());
        if (isLoaded != shouldLoad) {
            ChunkLoadingData.logInfo(shouldLoad, pos, uuid);
            level.setChunkForced(pos.x, pos.z, shouldLoad);
        }
        return updated;
    }

    public static void loadChunks(MinecraftServer server, UUID uuid, boolean shouldLoad) {
        for (Map.Entry<ResourceKey<Level>, Set<ChunkPos>> entry : ChunkLoadingData.getChunks(server, uuid).entrySet()) {
            ServerLevel dim = server.getLevel(entry.getKey());
            if (dim == null) continue;
            LongSet forcedChunks = dim.getForcedChunks();
            for (ChunkPos chunk : entry.getValue()) {
                boolean isLoaded = forcedChunks.contains(chunk.toLong());
                if (isLoaded) continue;
                ChunkLoadingData.logInfo(shouldLoad, chunk, uuid);
                dim.setChunkForced(chunk.x, chunk.z, shouldLoad);
            }
        }
    }
}

