/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.mixin.wixie;

import com.github.jarva.arsadditions.common.util.IWixieOutputStorage;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.SummoningTile;
import com.hollingsworth.arsnouveau.common.block.tile.WixieCauldronTile;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Mixin(value={WixieCauldronTile.class})
public abstract class WixieCauldronMixin
extends SummoningTile
implements IWandable,
IWixieOutputStorage {
    @Unique
    private BlockPos ars_additions$finishedStorage;

    public WixieCauldronMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    @Unique
    public BlockPos ars_additions$getOutputStorage() {
        return this.ars_additions$finishedStorage;
    }

    @Override
    public void ars_additions$setOutputStorage(BlockPos pos) {
        this.ars_additions$finishedStorage = pos;
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos == null || this.level == null) {
            return;
        }
        IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, storedPos, null);
        if (itemHandler == null) {
            return;
        }
        if (storedPos.equals((Object)this.ars_additions$finishedStorage)) {
            this.ars_additions$finishedStorage = null;
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"chat.ars_additions.wixie_cauldron.storage.cleared"));
        } else {
            this.ars_additions$finishedStorage = storedPos.immutable();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"chat.ars_additions.wixie_cauldron.storage.set"));
        }
        this.updateBlock();
    }

    @Inject(method={"onWanded"}, at={@At(value="HEAD")})
    private void clearStoragePosition(Player playerEntity, CallbackInfo ci) {
        if (this.ars_additions$finishedStorage != null) {
            this.ars_additions$finishedStorage = null;
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"chat.ars_additions.wixie_cauldron.storage.cleared"));
        }
    }

    @Inject(method={"getTooltip"}, at={@At(value="TAIL")})
    private void addTooltipLine(List<Component> tooltip, CallbackInfo ci) {
        if (this.ars_additions$finishedStorage != null) {
            tooltip.add((Component)Component.translatable((String)"tooltip.ars_additions.wixie_cauldron.storage"));
        }
    }

    @Inject(method={"getWandHighlight"}, at={@At(value="TAIL")})
    private void addWandHighlight(List<ColorPos> list, CallbackInfoReturnable<List<ColorPos>> cir) {
        if (this.ars_additions$finishedStorage != null) {
            list.add(ColorPos.centered((BlockPos)this.ars_additions$finishedStorage, (ParticleColor)ParticleColor.TO_HIGHLIGHT));
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void saveStoragePosition(CompoundTag compound, HolderLookup.Provider pRegistries, CallbackInfo ci) {
        if (this.ars_additions$finishedStorage != null) {
            compound.put("FinishedStorage", NbtUtils.writeBlockPos((BlockPos)this.ars_additions$finishedStorage));
        }
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    private void loadStoragePosition(CompoundTag compound, HolderLookup.Provider pRegistries, CallbackInfo ci) {
        this.ars_additions$finishedStorage = NbtUtils.readBlockPos((CompoundTag)compound, (String)"FinishedStorage").orElse(null);
    }
}

