/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.ritual.RitualChunkLoading;
import com.github.jarva.arsadditions.common.ritual.RitualLocateStructure;
import com.github.jarva.arsadditions.datagen.conditions.ConfigCondition;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.names.AddonBlockNames;
import com.hollingsworth.arsnouveau.api.registry.RitualRegistry;
import com.hollingsworth.arsnouveau.common.datagen.ItemTagProvider;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class RecipeDatagen
extends com.hollingsworth.arsnouveau.common.datagen.RecipeDatagen
implements IConditionBuilder {
    private final HashMap<ResourceLocation, Integer> STONECUTTER_COUNTER = new HashMap();

    public RecipeDatagen(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(packOutput, pRegistries);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput) {
        this.consumer = pRecipeOutput;
        this.addChainRecipe((ItemLike)AddonBlockRegistry.getBlock("archwood_chain"), (ItemLike)BlockRegistry.ARCHWOOD_PLANK);
        this.addChainRecipe((ItemLike)AddonBlockRegistry.getBlock("golden_chain"), (ItemLike)Items.GOLD_INGOT);
        this.addChainRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_chain"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"), true);
        this.addBiDirectionalRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_chain"), (ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_chain"), item -> item.withPrefix("crafting/chains/"));
        this.addStonecutter((ItemLike)AddonBlockRegistry.getBlock("sourcestone_chain"), (ItemLike)BlockRegistry.getBlock((String)"smooth_sourcestone"));
        this.addMagelightLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("archwood_magelight_lantern"), (ItemLike)BlockRegistry.ARCHWOOD_PLANK);
        this.addMagelightLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("golden_magelight_lantern"), (ItemLike)Items.GOLD_NUGGET);
        this.addMagelightLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_magelight_lantern"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"));
        this.addBiDirectionalRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_magelight_lantern"), (ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_magelight_lantern"), item -> item.withPrefix("crafting/lanterns/"));
        this.addMagelightLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("magelight_lantern"), (ItemLike)Items.IRON_INGOT);
        this.addMagelightLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("soul_magelight_lantern"), (ItemLike)Items.SOUL_SAND);
        this.addLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("archwood_lantern"), (ItemLike)BlockRegistry.ARCHWOOD_PLANK);
        this.addLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("golden_lantern"), (ItemLike)Items.GOLD_NUGGET);
        this.addLanternRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_lantern"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"));
        this.addBiDirectionalRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_lantern"), (ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_lantern"), item -> item.withPrefix("crafting/lanterns/"));
        this.addRitualRecipe(RitualChunkLoading.RESOURCE_LOCATION, builder -> builder.requires((ItemLike)BlockRegistry.CASCADING_LOG).requires((ItemLike)Items.NETHER_STAR).requires((ItemLike)ItemsRegistry.SOURCE_GEM).requires((ItemLike)ItemsRegistry.EARTH_ESSENCE), new ConfigCondition("ritual_enabled"));
        this.addButtonRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_button"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"), true);
        this.addButtonRecipe((ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_button"), (ItemLike)BlockRegistry.getBlock((String)"smooth_sourcestone"), true);
        this.addWallRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_wall"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"), true);
        this.addWallRecipe((ItemLike)AddonBlockRegistry.getBlock("cracked_sourcestone_wall"), (ItemLike)AddonBlockRegistry.getBlock("cracked_sourcestone"), true);
        this.addWallRecipe((ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_wall"), (ItemLike)BlockRegistry.getBlock((String)"smooth_sourcestone"), true);
        this.addWallRecipe((ItemLike)AddonBlockRegistry.getBlock("cracked_polished_sourcestone_wall"), (ItemLike)AddonBlockRegistry.getBlock("cracked_polished_sourcestone"), true);
        Block sourcestone = BlockRegistry.getBlock((String)"sourcestone");
        for (String name : AddonBlockNames.DECORATIVE_SOURCESTONES) {
            Block block = AddonBlockRegistry.getBlock(name);
            this.addStonecutter((ItemLike)sourcestone, (ItemLike)block);
            this.shapelessBuilder((ItemLike)sourcestone).requires((ItemLike)block).save(this.consumer, this.getRecipeId((ItemLike)block, "crafting/revert/", true).withSuffix("_to_sourcestone"));
        }
        this.addDoorRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_door"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"), true);
        this.addDoorRecipe((ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_door"), (ItemLike)BlockRegistry.getBlock((String)"smooth_sourcestone"), true);
        this.addTrapdoorRecipe((ItemLike)AddonBlockRegistry.getBlock("sourcestone_trapdoor"), (ItemLike)BlockRegistry.getBlock((String)"sourcestone"), true);
        this.addTrapdoorRecipe((ItemLike)AddonBlockRegistry.getBlock("polished_sourcestone_trapdoor"), (ItemLike)BlockRegistry.getBlock((String)"smooth_sourcestone"), true);
        this.addTrapdoorRecipe((ItemLike)AddonBlockRegistry.getBlock("magebloom_carpet"), (ItemLike)BlockRegistry.getBlock((String)"magebloom_block"));
        this.shapedBuilder((ItemLike)AddonItemRegistry.HANDY_HAVERSACK.get()).pattern("sgs").pattern("mem").pattern("mmm").define(Character.valueOf('s'), (ItemLike)Items.STRING).define(Character.valueOf('g'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('m'), (ItemLike)Items.PURPLE_WOOL).define(Character.valueOf('e'), (ItemLike)Items.ENDER_PEARL).save(this.consumer);
        this.shapedBuilder((ItemLike)AddonItemRegistry.WAYFINDER.get()).pattern(" g ").pattern("gag").pattern(" g ").define(Character.valueOf('g'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('a'), (ItemLike)Items.AMETHYST_SHARD).save(this.consumer);
        this.addRitualRecipe(RitualLocateStructure.RESOURCE_LOCATION, builder -> builder.requires((ItemLike)BlockRegistry.VEXING_LOG).requires((ItemLike)Items.COMPASS).requires(ItemTagProvider.SOURCE_GEM_TAG).requires((ItemLike)AddonItemRegistry.WAYFINDER.get()));
        this.addClearRecipe((ItemLike)AddonItemRegistry.ADVANCED_DOMINION_WAND.get());
        this.addClearRecipe((ItemLike)AddonItemRegistry.HANDY_HAVERSACK.get());
        this.addClearRecipe((ItemLike)AddonItemRegistry.XP_JAR.get());
    }

    public void addClearRecipe(ItemLike item) {
        this.shapelessBuilder(item).requires(item).save(this.consumer, this.getRecipeId(item, "clear_"));
    }

    public void addRitualRecipe(ResourceLocation id, Function<ShapelessRecipeBuilder, ShapelessRecipeBuilder> modifier) {
        this.addRitualRecipe(id, modifier, null);
    }

    public void addRitualRecipe(ResourceLocation id, Function<ShapelessRecipeBuilder, ShapelessRecipeBuilder> modifier, ICondition condition) {
        ShapelessRecipeBuilder ritualBuilder = modifier.apply(this.shapelessBuilder((ItemLike)RitualRegistry.getRitualItemMap().get(id)));
        if (condition != null) {
            RecipeOutput conditional = this.consumer.withConditions(new ICondition[]{condition});
            ritualBuilder.save(conditional, id.withPrefix("ritual/"));
        } else {
            ritualBuilder.save(this.consumer, id.withPrefix("ritual/"));
        }
    }

    public void addButtonRecipe(ItemLike result, ItemLike material) {
        this.addButtonRecipe(result, material, false);
    }

    public void addButtonRecipe(ItemLike result, ItemLike material, boolean stonecutter) {
        this.shapelessBuilder(result).requires(material).save(this.consumer, this.getRecipeId(result, "crafting/buttons/"));
        if (stonecutter) {
            this.addStonecutter(result, material);
        }
    }

    public void addTrapdoorRecipe(ItemLike result, ItemLike material) {
        this.addTrapdoorRecipe(result, material, false);
    }

    public void addTrapdoorRecipe(ItemLike result, ItemLike material, boolean stonecutter) {
        this.shapedBuilder(result).pattern("mm").define(Character.valueOf('m'), material).save(this.consumer, this.getRecipeId(result, "crafting/trapdoors/"));
        if (stonecutter) {
            this.addStonecutter(result, material);
        }
    }

    public void addDoorRecipe(ItemLike result, ItemLike material) {
        this.addDoorRecipe(result, material, false);
    }

    public void addDoorRecipe(ItemLike result, ItemLike material, boolean stonecutter) {
        this.shapedBuilder(result).pattern("mm").pattern("mm").pattern("mm").define(Character.valueOf('m'), material).save(this.consumer, this.getRecipeId(result, "crafting/doors/"));
        if (stonecutter) {
            this.addStonecutter(result, material);
        }
    }

    public void addWallRecipe(ItemLike result, ItemLike material) {
        this.addWallRecipe(result, material, false);
    }

    public void addWallRecipe(ItemLike result, ItemLike material, boolean stonecutter) {
        this.shapedBuilder(result, 6).pattern("   ").pattern("mmm").pattern("mmm").define(Character.valueOf('m'), material).save(this.consumer, RecipeBuilder.getDefaultRecipeId((ItemLike)result).withPrefix("crafting/walls/"));
        if (stonecutter) {
            this.addStonecutter(result, material);
        }
    }

    public void addChainRecipe(ItemLike result, ItemLike material) {
        this.addChainRecipe(result, material, false);
    }

    public void addChainRecipe(ItemLike result, ItemLike material, boolean stonecutter) {
        this.shapedBuilder(result).pattern("i").pattern("m").pattern("i").define(Character.valueOf('i'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('m'), material).save(this.consumer, this.getRecipeId(result, "crafting/chains/"));
        if (stonecutter) {
            this.addStonecutter(result, material);
        }
    }

    public void addMagelightLanternRecipe(ItemLike result, ItemLike material) {
        this.addLanternRecipe(result, material, (ItemLike)ItemsRegistry.SOURCE_GEM);
    }

    public void addLanternRecipe(ItemLike result, ItemLike material) {
        this.addLanternRecipe(result, material, (ItemLike)Items.TORCH);
    }

    public void addLanternRecipe(ItemLike result, ItemLike material, ItemLike center) {
        this.shapedBuilder(result).pattern("imi").pattern("msm").pattern("imi").define(Character.valueOf('i'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('m'), material).define(Character.valueOf('s'), center).save(this.consumer, this.getRecipeId(result, "crafting/lanterns/"));
    }

    public void addBiDirectionalRecipe(ItemLike a, ItemLike b) {
        this.addBiDirectionalRecipe(a, b, item -> item);
    }

    public void addBiDirectionalRecipe(ItemLike a, ItemLike b, Function<ResourceLocation, ResourceLocation> applicator) {
        this.shapelessBuilder(a).requires(b).save(this.consumer, applicator.apply(this.getRecipeId(a, "reversed_")));
        this.shapelessBuilder(b).requires(a).save(this.consumer, applicator.apply(this.getRecipeId(b, "reversed_")));
    }

    public void addStonecutter(ItemLike input, ItemLike output) {
        ResourceLocation location = this.getRecipeId(input, "crafting/stonecutter/", true);
        int counter = this.STONECUTTER_COUNTER.getOrDefault(location, 0);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output).unlockedBy("has_journal", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ItemsRegistry.WORN_NOTEBOOK})).save(this.consumer, location.withSuffix("_" + counter));
        this.STONECUTTER_COUNTER.put(location, counter + 1);
    }

    public ResourceLocation getRecipeId(ItemLike input) {
        return this.getRecipeId(input, "", false);
    }

    public ResourceLocation getRecipeId(ItemLike input, String prefix) {
        return this.getRecipeId(input, prefix, false);
    }

    public ResourceLocation getRecipeId(ItemLike input, String prefix, boolean convert) {
        ResourceLocation loc = RecipeBuilder.getDefaultRecipeId((ItemLike)input).withPrefix(prefix);
        return convert ? ArsAdditions.prefix(loc.getPath()) : loc;
    }
}

