/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.datagen;

import com.github.jarva.arsadditions.common.perk.ReachPerk;
import com.github.jarva.arsadditions.datagen.EnchantmentDatagen;
import com.github.jarva.arsadditions.datagen.Setup;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.github.jarva.arsadditions.setup.registry.CharmRegistry;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class EnchantingAppDatagen
extends ApparatusRecipeProvider {
    public EnchantingAppDatagen(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/" + Setup.root + "/recipe/apparatus/" + str + ".json");
    }

    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (ApparatusRecipeBuilder.RecipeWrapper recipe : this.recipes) {
            Path path = EnchantingAppDatagen.getRecipePath(this.output, recipe.id().getPath());
            this.saveStable(pOutput, recipe.serialize(), path);
        }
    }

    public void addEntries() {
        this.addRecipe(this.builder().withResult(AddonItemRegistry.LECTERN_REMOTE).withReagent((ItemLike)ItemsRegistry.MUNDANE_BELT).withPedestalItem(1, (ItemLike)ItemsRegistry.SCRY_CASTER).withPedestalItem(1, (ItemLike)BlockRegistry.SCRYERS_CRYSTAL).withPedestalItem(1, (ItemLike)ItemsRegistry.STARBUNCLE_CHARM).withPedestalItem(1, (ItemLike)ItemsRegistry.BOOKWYRM_CHARM).build());
        this.addRecipe(this.builder().withResult(AddonItemRegistry.ADVANCED_LECTERN_REMOTE).withReagent(AddonItemRegistry.LECTERN_REMOTE).withPedestalItem(1, (ItemLike)Items.NETHERITE_INGOT).withPedestalItem(1, (ItemLike)Items.NETHER_STAR).withPedestalItem(1, (ItemLike)Blocks.ENDER_CHEST).build());
        this.addRecipe(this.builder().withResult(AddonBlockRegistry.ENDER_SOURCE_JAR).withReagent((ItemLike)BlockRegistry.SOURCE_JAR).withPedestalItem(4, (ItemLike)Items.ENDER_PEARL).withPedestalItem(4, (ItemLike)Items.POPPED_CHORUS_FRUIT).build());
        this.addRecipe(this.builder().withResult(AddonItemRegistry.UNSTABLE_RELIQUARY).withReagent((ItemLike)BlockRegistry.MOB_JAR).withPedestalItem(1, (ItemLike)ItemsRegistry.CONJURATION_ESSENCE).withPedestalItem(1, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).withPedestalItem(1, (ItemLike)Items.ENDER_PEARL).build());
        this.addRecipe(this.builder().withResult(AddonItemRegistry.XP_JAR).withReagent((ItemLike)Items.GLASS_BOTTLE).withPedestalItem((ItemLike)ItemsRegistry.ALLOW_ITEM_SCROLL).withPedestalItem((ItemLike)Blocks.FURNACE).withPedestalItem((ItemLike)Blocks.COBBLESTONE).withPedestalItem(Ingredient.of((TagKey)ItemTags.COALS)).withPedestalItem((ItemLike)Items.LAPIS_LAZULI).build());
        this.addRecipe(this.builder().withResult(AddonItemRegistry.ADVANCED_DOMINION_WAND).withReagent((ItemLike)ItemsRegistry.DOMINION_ROD).withPedestalItem((ItemLike)Items.AMETHYST_BLOCK).withPedestalItem((ItemLike)Items.GOLD_INGOT).withPedestalItem((ItemLike)Items.GOLD_INGOT).build());
        this.addRecipe(this.builder().withResult((ItemLike)AddonBlockRegistry.SOURCE_SPAWNER.get()).withReagent((ItemLike)ItemsRegistry.DRYGMY_CHARM).withPedestalItem((ItemLike)ItemsRegistry.SUMMONING_FOCUS).withPedestalItem((ItemLike)ItemsRegistry.CONJURATION_ESSENCE).build());
        this.addRecipe(this.builder().withResult((ItemLike)this.getPerkItem(ReachPerk.INSTANCE.getRegistryName())).withReagent((ItemLike)ItemsRegistry.BLANK_THREAD).withPedestalItem(3, (ItemLike)ItemsRegistry.ALAKARKINOS_SHARD).withPedestalItem(3, (ItemLike)ItemsRegistry.MANIPULATION_ESSENCE).build());
        this.addRecipe(this.builder().withPedestalItem((ItemLike)ItemsRegistry.BLANK_THREAD).withPedestalItem(4, (ItemLike)ItemsRegistry.MAGE_FIBER).withPedestalItem((ItemLike)BlockRegistry.SOURCE_GEM_BLOCK).withPedestalItem((ItemLike)Items.DIAMOND_BLOCK).withPedestalItem(2, (ItemLike)Items.LAPIS_BLOCK).buildEnchantmentRecipe(EnchantmentDatagen.SPELLWEAVE_ENCHANTMENT, 1, 10000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.of((TagKey)Tags.Items.RODS_BLAZE)).withPedestalItem(2, (ItemLike)Items.DIAMOND_BLOCK).withPedestalItem((ItemLike)Items.LAPIS_BLOCK).withPedestalItem((ItemLike)BlockRegistry.SOURCE_GEM_BLOCK).buildEnchantmentRecipe(EnchantmentDatagen.SPELLWEAVE_ENCHANTMENT, 2, 20000));
        this.addRecipe(this.builder().withPedestalItem(2, Ingredient.of((TagKey)Tags.Items.ENDER_PEARLS)).withPedestalItem((ItemLike)Items.CHORUS_FRUIT).withPedestalItem((ItemLike)ItemsRegistry.WILDEN_TRIBUTE).withPedestalItem(3, (ItemLike)Items.DIAMOND_BLOCK).withPedestalItem((ItemLike)Items.LAPIS_BLOCK).buildEnchantmentRecipe(EnchantmentDatagen.SPELLWEAVE_ENCHANTMENT, 3, 30000));
        for (CharmRegistry.CharmType charmType : CharmRegistry.CharmType.values()) {
            ApparatusRecipeBuilder builder = this.builder().withResult((ItemLike)AddonItemRegistry.CHARMS.get((Object)charmType)).withReagent((ItemLike)Items.GLASS_BOTTLE);
            for (ItemLike item : charmType.getPedestalItems()) {
                builder.withPedestalItem(item);
            }
            this.addRecipe(builder.build());
        }
    }
}

