/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item.curios;

import com.github.jarva.arsadditions.common.item.data.WarpBindData;
import com.github.jarva.arsadditions.common.util.LangUtil;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class WarpIndex
extends Item {
    public WarpIndex() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)WarpBindData.fromItemStack(stack).map(data -> Component.translatable((String)"tooltip.ars_additions.warp_index.bound", (Object[])new Object[]{data.x(), data.y(), data.z(), data.getDimensionString()})).orElse(Component.translatable((String)"chat.ars_additions.warp_index.unbound", (Object[])new Object[]{Component.keybind((String)"key.sneak"), Component.keybind((String)"key.use"), LangUtil.storageLectern()})));
        tooltip.add((Component)Component.translatable((String)"tooltip.ars_additions.warp_index.keybind", (Object[])new Object[]{Component.translatable((String)"tooltip.ars_additions.warp_index.keybind.outline", (Object[])new Object[]{Component.keybind((String)"key.ars_additions.open_lectern")}).withStyle(ChatFormatting.GREEN)}));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        return new InteractionResultHolder(this.activateTerminal(worldIn, playerIn.getItemInHand(handIn), playerIn, handIn), (Object)playerIn.getItemInHand(handIn));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext c) {
        if (!c.isSecondaryUseActive()) {
            return InteractionResult.PASS;
        }
        if (c.getLevel().isClientSide()) {
            return InteractionResult.CONSUME;
        }
        BlockPos pos = c.getClickedPos();
        BlockState state = c.getLevel().getBlockState(pos);
        if (state.is((Block)BlockRegistry.CRAFTING_LECTERN.get())) {
            ItemStack stack = c.getItemInHand();
            new WarpBindData(c.getLevel(), pos).write(stack);
            if (c.getPlayer() != null) {
                c.getPlayer().displayClientMessage((Component)Component.translatable((String)"chat.ars_additions.warp_index.bound", (Object[])new Object[]{LangUtil.storageLectern()}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult activateTerminal(Level worldIn, ItemStack stack, Player playerIn, InteractionHand handIn) {
        Optional<WarpBindData> dataOptional = WarpBindData.fromItemStack(stack);
        if (dataOptional.isEmpty()) {
            playerIn.displayClientMessage((Component)Component.translatable((String)"chat.ars_additions.warp_index.unbound", (Object[])new Object[]{Component.keybind((String)"key.sneak"), Component.keybind((String)"key.use"), LangUtil.storageLectern()}), true);
            return InteractionResult.PASS;
        }
        if (!this.canActivate(worldIn, stack, playerIn, handIn)) {
            playerIn.displayClientMessage((Component)Component.translatable((String)"chat.ars_additions.warp_index.no_activate", (Object[])new Object[]{LangUtil.storageLectern()}), true);
            return InteractionResult.PASS;
        }
        if (worldIn.isClientSide) {
            return InteractionResult.CONSUME;
        }
        MinecraftServer server = worldIn.getServer();
        if (server == null) {
            return InteractionResult.CONSUME;
        }
        WarpBindData data = dataOptional.get();
        ResourceKey<Level> dim = data.dimension();
        BlockPos boundPos = data.blockPos();
        ServerLevel lecternWorld = server.getLevel(dim);
        if (lecternWorld == null || !lecternWorld.isLoaded(boundPos)) {
            playerIn.displayClientMessage((Component)Component.translatable((String)"chat.ars_additions.warp_index.out_of_range", (Object[])new Object[]{LangUtil.storageLectern()}), true);
            return InteractionResult.FAIL;
        }
        BlockState state = lecternWorld.getBlockState(boundPos);
        if (!state.is((Block)BlockRegistry.CRAFTING_LECTERN.get())) {
            playerIn.displayClientMessage((Component)Component.translatable((String)"chat.ars_additions.warp_index.invalid_block", (Object[])new Object[]{LangUtil.storageLectern()}), true);
            return InteractionResult.FAIL;
        }
        BlockHitResult lookingAt = new BlockHitResult(Vec3.atLowerCornerOf((Vec3i)boundPos), Direction.UP, boundPos, true);
        return state.useItemOn(stack, (Level)lecternWorld, playerIn, handIn, lookingAt).result();
    }

    public boolean canActivate(Level worldIn, ItemStack stack, Player playerIn, InteractionHand handIn) {
        return WarpBindData.fromItemStack(stack).map(data -> data.isIn((ResourceKey<Level>)worldIn.dimension())).orElse(false);
    }

    public void open(Player sender, ItemStack t) {
        this.activateTerminal(sender.level(), t, sender, InteractionHand.MAIN_HAND);
    }
}

