/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.glyph;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.item.UnstableReliquary;
import com.github.jarva.arsadditions.common.item.data.mark.EntityMarkData;
import com.github.jarva.arsadditions.common.item.data.mark.LocationMarkData;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonEffectRegistry;
import com.github.jarva.arsadditions.setup.registry.names.AddonGlyphNames;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class EffectMark
extends AbstractEffect {
    public static EffectMark INSTANCE = new EffectMark();

    public EffectMark() {
        super(ArsAdditions.prefix(AddonGlyphNames.EffectMark), "Mark");
    }

    public String getBookDescription() {
        return "Marks the target and stores the mark in a Reliquary.";
    }

    public void onResolveBlock(BlockHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ItemStack reliquary = UnstableReliquary.getReliquaryFromCaster(spellContext, shooter);
        if (reliquary == null) {
            return;
        }
        BlockPos pos = rayTraceResult.getBlockPos();
        reliquary.set(AddonDataComponentRegistry.MARK_DATA, (Object)new LocationMarkData(new GlobalPos(world.dimension(), pos)));
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level world, @NotNull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        ItemStack reliquary = UnstableReliquary.getReliquaryFromCaster(spellContext, shooter);
        if (reliquary == null) {
            return;
        }
        Entity entity = rayTraceResult.getEntity();
        Optional<Component> name = Optional.empty();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            name = Optional.ofNullable(player.getDisplayName());
            player.addEffect(new MobEffectInstance(AddonEffectRegistry.MARKED_EFFECT, (Integer)ServerConfig.SERVER.reliquary_effect_duration.get() * 20));
        }
        reliquary.set(AddonDataComponentRegistry.MARK_DATA, (Object)new EntityMarkData(entity.getUUID(), (Holder<EntityType<?>>)entity.getType().builtInRegistryHolder(), name));
    }

    protected int getDefaultManaCost() {
        return 25;
    }

    public SpellTier defaultTier() {
        return SpellTier.THREE;
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.PER_SPELL_LIMIT = builder.comment("The maximum number of times this glyph may appear in a single spell").defineInRange("per_spell_limit", 1, 1, 1);
    }

    @NotNull
    protected Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }
}

