/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.client.renderers.EnchantingWixieCauldronRenderer;
import com.github.jarva.arsadditions.client.renderers.tile.WarpNexusRenderer;
import com.github.jarva.arsadditions.client.util.BookUtil;
import com.github.jarva.arsadditions.client.util.CompassUtil;
import com.github.jarva.arsadditions.common.block.EnderSourceJar;
import com.github.jarva.arsadditions.common.item.data.HaversackData;
import com.github.jarva.arsadditions.common.util.FillUtil;
import com.github.jarva.arsadditions.setup.networking.OpenTerminalPacket;
import com.github.jarva.arsadditions.setup.registry.AddonBlockRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.github.jarva.arsadditions.setup.registry.AddonItemRegistry;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.items.data.BlockFillContents;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import vazkii.patchouli.api.BookContentsReloadEvent;
import vazkii.patchouli.client.book.BookPage;

public class ArsAdditionsClient {
    public static KeyMapping openTerm;

    public static void clientSetup() {
    }

    @EventBusSubscriber(modid="ars_additions", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
    public static class ClientForgeEvents {
        @SubscribeEvent
        public static void clientTick(ClientTickEvent.Post evt) {
            if (Minecraft.getInstance().player == null) {
                return;
            }
            if (openTerm.consumeClick()) {
                OpenTerminalPacket.openTerminal();
            }
        }

        @SubscribeEvent
        public static void updateBookContents(BookContentsReloadEvent event) {
            ResourceLocation bookId = event.getBook();
            if (!bookId.equals((Object)BookUtil.WORN_NOTEBOOK)) {
                return;
            }
            BookUtil.addRelation(ArsNouveau.prefix((String)"machines/storage_lectern"), ArsNouveau.prefix((String)"machines/warp_indexes"));
            BookPage wixiePage = BookUtil.newTextPage("ars_additions.page.wixie_enchanting_apparatus", "ars_additions.page1.wixie_enchanting_apparatus");
            BookUtil.addPage(ArsNouveau.prefix((String)"automation/wixie_charm"), wixiePage, true, page -> BookUtil.isTitlePage(page, "ars_nouveau.binding_inventories"));
            BookPage bulkScribing = BookUtil.newTextPage("ars_additions.page.bulk_scribing", "ars_additions.page1.bulk_scribing");
            BookUtil.addPage(ArsNouveau.prefix((String)"machines/scribes_block"), bulkScribing, true, page -> BookUtil.isTitlePage(page, "ars_nouveau.scribing"));
        }
    }

    @EventBusSubscriber(modid="ars_additions", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void initKeybinds(RegisterKeyMappingsEvent evt) {
            openTerm = new KeyMapping("key.ars_additions.open_lectern", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.UNKNOWN, "key.category.ars_nouveau.general");
            evt.register(openTerm);
        }

        @SubscribeEvent
        public static void init(FMLClientSetupEvent evt) {
            ArsAdditions.LOGGER.info("Running init");
            evt.enqueueWork(() -> {
                ItemProperties.register((Item)((EnderSourceJar)((Object)((Object)AddonBlockRegistry.ENDER_SOURCE_JAR.get()))).asItem(), (ResourceLocation)ArsAdditions.prefix("source"), (stack, level, entity, seed) -> {
                    if (!stack.has(DataComponents.BLOCK_ENTITY_DATA)) {
                        return 0.0f;
                    }
                    int source = BlockFillContents.get((ItemStack)stack);
                    return FillUtil.getFillLevel(source);
                });
                ItemProperties.register((Item)((Item)AddonItemRegistry.HANDY_HAVERSACK.get()), (ResourceLocation)ArsAdditions.prefix("loaded"), (stack, level, entity, seed) -> {
                    HaversackData data = (HaversackData)stack.get(AddonDataComponentRegistry.HAVERSACK_DATA);
                    return data != null && data.loaded() != false ? 0.0f : 1.0f;
                });
                ItemProperties.register((Item)((Item)AddonItemRegistry.WAYFINDER.get()), (ResourceLocation)ArsAdditions.prefix("angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((CompassItemPropertyFunction.CompassTarget)new CompassUtil()));
                ItemProperties.register((Item)((Item)AddonItemRegistry.WAYFINDER.get()), (ResourceLocation)ArsAdditions.prefix("pos"), (stack, level, entity, seed) -> stack.has(AddonDataComponentRegistry.WAYFINDER_DATA) ? 1.0f : 0.0f);
            });
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)AddonBlockRegistry.WARP_NEXUS_TILE.get(), WarpNexusRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)AddonBlockRegistry.WIXIE_ENCHANTING_TILE.get(), EnchantingWixieCauldronRenderer::new);
        }
    }
}

