/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen;

import it.zerono.mods.extremereactors.CommonLocations;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.compat.patchouli.PatchouliCompat;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.client.screen.CommonMultiblockScreen;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.client.screen.control.ReactorControllerPanel;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.container.ReactorControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.ReactorControllerEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.base.client.screen.ClientBaseHelper;
import it.zerono.mods.zerocore.base.client.screen.control.MachineStatusIndicator;
import it.zerono.mods.zerocore.lib.client.gui.ButtonState;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractButtonControl;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.item.inventory.PlayerInventoryUsage;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.apache.logging.log4j.util.TriConsumer;

public class ReactorControllerScreen
extends CommonMultiblockScreen<MultiblockReactor, ReactorControllerEntity, ReactorControllerContainer> {
    private final ReactorControllerPanel _controllerPanel;

    public ReactorControllerScreen(ReactorControllerContainer container, Inventory inventory, Component title) {
        super(container, inventory, PlayerInventoryUsage.None, title, ReactorControllerScreen.mainTextureFromVariant((IMultiblockVariant)((ReactorControllerEntity)container.getTileEntity()).getMultiblockVariant().orElse(ReactorVariant.Basic)));
        this.addPatchouliHelpButton(PatchouliCompat.HANDBOOK_ID, CommonLocations.REACTOR.buildWithSuffix("part-controller"), 1);
        this.addRecipesButton(() -> this.displayReactorRecipes(), "gui.bigreactors.show_recipes.tooltip.title");
        this.setContentBounds(14, 0);
        this._controllerPanel = new ReactorControllerPanel((ModContainerScreen<? extends ModContainer>)this, this.getContentWidth(), this.getContentHeight(), container, this::onActiveStateChanged, this::onWasteEjectionChanged, this::onVoidReactants, this::onScram, (TriConsumer<AbstractButtonControl, ButtonState, Supplier<ISprite>>)((TriConsumer)ClientBaseHelper::setButtonSpritesAndOverlayForState));
    }

    @Override
    protected MachineStatusIndicator createStatusIndicator(ReactorControllerContainer container) {
        return this.createReactorStatusIndicator(container.active());
    }

    protected void onScreenCreate() {
        super.onScreenCreate();
        this.addControl((IControl)this._controllerPanel);
    }

    private void onActiveStateChanged(boolean active) {
        if (!this.isDataUpdateInProgress()) {
            this.sendCommandToServer(active ? CommonConstants.COMMAND_ACTIVATE : CommonConstants.COMMAND_DEACTIVATE);
        }
    }

    private void onWasteEjectionChanged(boolean active) {
        this.sendCommandToServer(active ? ReactorControllerEntity.COMMAND_WASTE_AUTOMATIC : ReactorControllerEntity.COMMAND_WASTE_MANUAL);
    }

    private void onScram() {
        this.sendCommandToServer(ReactorControllerEntity.COMMAND_SCRAM);
    }

    private void onVoidReactants() {
        this.sendCommandToServer(ReactorControllerEntity.COMMAND_VOID_REACTANTS);
    }
}

