/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part;

import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.FluidizerTankData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.MultiblockFluidizer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.container.FluidizerControllerContainer;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.part.AbstractFluidizerEntity;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.network.INetworkTileEntitySyncProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.fml.LogicalSide;
import org.jetbrains.annotations.Nullable;

public class FluidizerControllerEntity
extends AbstractFluidizerEntity
implements MenuProvider,
INetworkTileEntitySyncProvider {
    @Nullable
    private FluidizerTankData _tankRenderData;
    private AABB _renderBoundingBox;

    public FluidizerControllerEntity(BlockPos position, BlockState blockState) {
        super(Content.TileEntityTypes.FLUIDIZER_CONTROLLER.get(), position, blockState);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_ACTIVATE, rce -> rce.setFluidizerActive(true)).addServerHandler(CommonConstants.COMMAND_DEACTIVATE, rce -> rce.setFluidizerActive(false)).build((AbstractModBlockEntity)this));
        this._renderBoundingBox = AABB.INFINITE;
    }

    @Nullable
    public FluidizerTankData getTankData() {
        return this._tankRenderData;
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return (byte)(this.isMachineAssembled() ? (this.isFluidizerActive() ? 1 : 2) : 0);
    }

    public AABB getRenderBoundingBox() {
        return this._renderBoundingBox;
    }

    public void onPostMachineAssembled(MultiblockFluidizer controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.listenForControllerDataUpdates();
        if (this.getCurrentWorld().isClientSide()) {
            this._tankRenderData = ExtremeReactors.getProxy().createFluidizerTankData(this);
            this._renderBoundingBox = controller.getBoundingBox().getAABB().inflate(16.0);
        }
    }

    @Override
    public void onMachineActivated() {
        super.onMachineActivated();
        this.requestClientRenderUpdate();
    }

    @Override
    public void onMachineDeactivated() {
        super.onMachineDeactivated();
        this.requestClientRenderUpdate();
    }

    @Override
    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        return position.isFace() || super.isGoodForPosition(position, validatorCallback);
    }

    @Override
    public void getDebugMessages(LogicalSide side, IDebugMessages messages) {
        super.getDebugMessages(side, messages);
        this.executeOnController(c -> c.getDebugMessages(side, messages));
    }

    public boolean canOpenGui(Level world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    public void enlistForUpdates(ServerPlayer player, boolean updateNow) {
        this.executeOnController(c -> c.enlistForUpdates(player, updateNow));
    }

    public void delistFromUpdates(ServerPlayer player) {
        this.executeOnController(c -> c.delistFromUpdates(player));
    }

    public void sendUpdates() {
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        return new FluidizerControllerContainer(windowId, inventory, this);
    }

    public Component getDisplayName() {
        return super.getPartDisplayName();
    }
}

